/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.anthropic.api;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.ai.anthropic.api.AnthropicCacheStrategy;
import org.springframework.ai.anthropic.api.AnthropicCacheTtl;
import org.springframework.ai.chat.messages.MessageType;

public class AnthropicCacheOptions {
    public static AnthropicCacheOptions DISABLED = new AnthropicCacheOptions();
    private static final int DEFAULT_MIN_CONTENT_LENGTH = 1;
    private AnthropicCacheStrategy strategy = AnthropicCacheStrategy.NONE;
    private Function<String, Integer> contentLengthFunction = s -> s != null ? s.length() : 0;
    private Map<MessageType, AnthropicCacheTtl> messageTypeTtl = Stream.of(MessageType.values()).collect(Collectors.toMap(mt -> mt, mt -> AnthropicCacheTtl.FIVE_MINUTES, (m1, m2) -> m1, HashMap::new));
    private Map<MessageType, Integer> messageTypeMinContentLengths = Stream.of(MessageType.values()).collect(Collectors.toMap(mt -> mt, mt -> 1, (m1, m2) -> m1, HashMap::new));

    public static Builder builder() {
        return new Builder();
    }

    public AnthropicCacheStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(AnthropicCacheStrategy strategy) {
        this.strategy = strategy;
    }

    public Function<String, Integer> getContentLengthFunction() {
        return this.contentLengthFunction;
    }

    public void setContentLengthFunction(Function<String, Integer> contentLengthFunction) {
        this.contentLengthFunction = contentLengthFunction;
    }

    public Map<MessageType, AnthropicCacheTtl> getMessageTypeTtl() {
        return this.messageTypeTtl;
    }

    public void setMessageTypeTtl(Map<MessageType, AnthropicCacheTtl> messageTypeTtl) {
        this.messageTypeTtl = messageTypeTtl;
    }

    public Map<MessageType, Integer> getMessageTypeMinContentLengths() {
        return this.messageTypeMinContentLengths;
    }

    public void setMessageTypeMinContentLengths(Map<MessageType, Integer> messageTypeMinContentLengths) {
        this.messageTypeMinContentLengths = messageTypeMinContentLengths;
    }

    public String toString() {
        return "AnthropicCacheOptions{strategy=" + String.valueOf((Object)this.strategy) + ", contentLengthFunction=" + String.valueOf(this.contentLengthFunction) + ", messageTypeTtl=" + String.valueOf(this.messageTypeTtl) + ", messageTypeMinContentLengths=" + String.valueOf(this.messageTypeMinContentLengths) + "}";
    }

    public static class Builder {
        private final AnthropicCacheOptions options = new AnthropicCacheOptions();

        public Builder strategy(AnthropicCacheStrategy strategy) {
            this.options.setStrategy(strategy);
            return this;
        }

        public Builder contentLengthFunction(Function<String, Integer> contentLengthFunction) {
            this.options.setContentLengthFunction(contentLengthFunction);
            return this;
        }

        public Builder messageTypeTtl(Map<MessageType, AnthropicCacheTtl> messageTypeTtl) {
            this.options.setMessageTypeTtl(messageTypeTtl);
            return this;
        }

        public Builder messageTypeTtl(MessageType messageType, AnthropicCacheTtl ttl) {
            this.options.messageTypeTtl.put(messageType, ttl);
            return this;
        }

        public Builder messageTypeMinContentLengths(Map<MessageType, Integer> messageTypeMinContentLengths) {
            this.options.setMessageTypeMinContentLengths(messageTypeMinContentLengths);
            return this;
        }

        public Builder messageTypeMinContentLength(MessageType messageType, Integer minContentLength) {
            this.options.messageTypeMinContentLengths.put(messageType, minContentLength);
            return this;
        }

        public AnthropicCacheOptions build() {
            return this.options;
        }
    }
}

