/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.core.configuration;

import java.util.Optional;
import org.springdoc.core.configuration.SpringDocConfiguration;
import org.springdoc.core.customizers.SpringDocCustomizers;
import org.springdoc.core.discoverer.SpringDocParameterNameDiscoverer;
import org.springdoc.core.extractor.MethodParameterPojoExtractor;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.providers.ActuatorProvider;
import org.springdoc.core.providers.SpringDocProviders;
import org.springdoc.core.providers.SpringWebProvider;
import org.springdoc.core.service.AbstractRequestService;
import org.springdoc.core.service.GenericParameterService;
import org.springdoc.core.service.GenericResponseService;
import org.springdoc.core.service.OpenAPIService;
import org.springdoc.core.service.OperationService;
import org.springdoc.core.service.RequestBodyService;
import org.springdoc.core.utils.PropertyResolverUtils;
import org.springdoc.core.utils.SpringDocUtils;
import org.springdoc.webmvc.api.OpenApiActuatorResource;
import org.springdoc.webmvc.api.OpenApiWebMvcResource;
import org.springdoc.webmvc.core.configuration.MultipleOpenApiSupportConfiguration;
import org.springdoc.webmvc.core.providers.ActuatorWebMvcProvider;
import org.springdoc.webmvc.core.providers.RouterFunctionWebMvcProvider;
import org.springdoc.webmvc.core.providers.SpringWebMvcProvider;
import org.springdoc.webmvc.core.service.RequestService;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ConditionalOnManagementPort;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.actuate.endpoint.web.servlet.WebMvcEndpointHandlerMapping;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@Lazy(value=false)
@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnProperty(name={"springdoc.api-docs.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={SpringDocConfiguration.class})
public class SpringDocWebMvcConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnExpression(value="(${springdoc.use-management-port:false} == false ) and ${springdoc.enable-default-api-docs:true}")
    @Lazy(value=false)
    OpenApiWebMvcResource openApiResource(ObjectFactory<OpenAPIService> openAPIBuilderObjectFactory, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, SpringDocConfigProperties springDocConfigProperties, SpringDocProviders springDocProviders, SpringDocCustomizers springDocCustomizers) {
        return new OpenApiWebMvcResource(openAPIBuilderObjectFactory, requestBuilder, responseBuilder, operationParser, springDocConfigProperties, springDocProviders, springDocCustomizers);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    RequestService requestBuilder(GenericParameterService parameterBuilder, RequestBodyService requestBodyService, SpringDocCustomizers springDocCustomizers, SpringDocParameterNameDiscoverer localSpringDocParameterNameDiscoverer, MethodParameterPojoExtractor methodParameterPojoExtractor) {
        return new RequestService(parameterBuilder, requestBodyService, springDocCustomizers, localSpringDocParameterNameDiscoverer, methodParameterPojoExtractor);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    SpringWebProvider springWebProvider() {
        return new SpringWebMvcProvider();
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    GenericResponseService responseBuilder(OperationService operationService, SpringDocConfigProperties springDocConfigProperties, PropertyResolverUtils propertyResolverUtils) {
        return new GenericResponseService(operationService, springDocConfigProperties, propertyResolverUtils);
    }

    static {
        SpringDocUtils.getConfig().setResponseEntityExceptionHandlerClass(ResponseEntityExceptionHandler.class).setModelAndViewClass(ModelAndView.class);
    }

    @ConditionalOnClass(value={WebMvcEndpointHandlerMapping.class})
    static class SpringDocWebMvcActuatorConfiguration {
        SpringDocWebMvcActuatorConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnExpression(value="${springdoc.show-actuator:false} or ${springdoc.use-management-port:false}")
        @Lazy(value=false)
        ActuatorProvider actuatorProvider(ServerProperties serverProperties, SpringDocConfigProperties springDocConfigProperties, Optional<ManagementServerProperties> managementServerProperties, Optional<WebEndpointProperties> webEndpointProperties) {
            return new ActuatorWebMvcProvider(serverProperties, springDocConfigProperties, managementServerProperties, webEndpointProperties);
        }

        @Bean
        @ConditionalOnMissingBean(value={MultipleOpenApiSupportConfiguration.class})
        @ConditionalOnExpression(value="${springdoc.use-management-port:false} and ${springdoc.enable-default-api-docs:true}")
        @ConditionalOnManagementPort(value=ManagementPortType.DIFFERENT)
        @Lazy(value=false)
        OpenApiActuatorResource openApiActuatorResource(ObjectFactory<OpenAPIService> openAPIBuilderObjectFactory, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, SpringDocConfigProperties springDocConfigProperties, SpringDocProviders springDocProviders, SpringDocCustomizers springDocCustomizers) {
            return new OpenApiActuatorResource(openAPIBuilderObjectFactory, requestBuilder, responseBuilder, operationParser, springDocConfigProperties, springDocProviders, springDocCustomizers);
        }
    }

    @ConditionalOnClass(value={RouterFunction.class})
    static class SpringDocWebMvcRouterConfiguration {
        SpringDocWebMvcRouterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @Lazy(value=false)
        RouterFunctionWebMvcProvider routerFunctionProvider() {
            return new RouterFunctionWebMvcProvider();
        }
    }
}

