/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.provider.elicitation;

import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springaicommunity.mcp.annotation.McpElicitation;
import org.springaicommunity.mcp.method.elicitation.SyncElicitationSpecification;
import org.springaicommunity.mcp.method.elicitation.SyncMcpElicitationMethodCallback;
import org.springaicommunity.mcp.provider.McpProviderUtils;

public class SyncMcpElicitationProvider {
    private static final Logger logger = LoggerFactory.getLogger(SyncMcpElicitationProvider.class);
    private final List<Object> elicitationObjects;

    public SyncMcpElicitationProvider(List<Object> elicitationObjects) {
        Assert.notNull(elicitationObjects, (String)"elicitationObjects cannot be null");
        this.elicitationObjects = elicitationObjects;
    }

    public List<SyncElicitationSpecification> getElicitationSpecifications() {
        List<SyncElicitationSpecification> elicitationHandlers = this.elicitationObjects.stream().map(elicitationObject -> Stream.of(this.doGetClassMethods(elicitationObject)).filter(method -> method.isAnnotationPresent(McpElicitation.class)).filter(McpProviderUtils.filterReactiveReturnTypeMethod()).filter(method -> McpSchema.ElicitResult.class.isAssignableFrom(method.getReturnType())).filter(method -> method.getParameterCount() == 1 && McpSchema.ElicitRequest.class.isAssignableFrom(method.getParameterTypes()[0])).sorted((m1, m2) -> m1.getName().compareTo(m2.getName())).map(mcpElicitationMethod -> {
            McpElicitation elicitationAnnotation = mcpElicitationMethod.getAnnotation(McpElicitation.class);
            SyncMcpElicitationMethodCallback methodCallback = ((SyncMcpElicitationMethodCallback.Builder)((SyncMcpElicitationMethodCallback.Builder)((SyncMcpElicitationMethodCallback.Builder)SyncMcpElicitationMethodCallback.builder().method((Method)mcpElicitationMethod)).bean(elicitationObject)).elicitation(elicitationAnnotation)).build();
            return new SyncElicitationSpecification(elicitationAnnotation.clients(), methodCallback);
        }).toList()).flatMap(Collection::stream).toList();
        if (elicitationHandlers.isEmpty()) {
            logger.warn("No elicitation methods found");
        }
        if (elicitationHandlers.size() > 1) {
            logger.warn("Multiple elicitation methods found: " + elicitationHandlers.size());
        }
        return elicitationHandlers;
    }

    protected Method[] doGetClassMethods(Object bean) {
        return bean.getClass().getDeclaredMethods();
    }
}

