/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.provider.progress;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.springaicommunity.mcp.annotation.McpProgress;
import org.springaicommunity.mcp.method.progress.SyncMcpProgressMethodCallback;
import org.springaicommunity.mcp.method.progress.SyncProgressSpecification;
import reactor.core.publisher.Mono;

public class SyncMcpProgressProvider {
    private final List<Object> progressObjects;

    public SyncMcpProgressProvider(List<Object> progressObjects) {
        this.progressObjects = progressObjects != null ? progressObjects : List.of();
    }

    public List<SyncProgressSpecification> getProgressSpecifications() {
        List<SyncProgressSpecification> progressConsumers = this.progressObjects.stream().map(progressObject -> Stream.of(this.doGetClassMethods(progressObject)).filter(method -> method.isAnnotationPresent(McpProgress.class)).filter(method -> !Mono.class.isAssignableFrom(method.getReturnType())).filter(method -> method.getReturnType() == Void.TYPE).map(mcpProgressMethod -> {
            McpProgress progressAnnotation = mcpProgressMethod.getAnnotation(McpProgress.class);
            SyncMcpProgressMethodCallback methodCallback = ((SyncMcpProgressMethodCallback.Builder)((SyncMcpProgressMethodCallback.Builder)((SyncMcpProgressMethodCallback.Builder)SyncMcpProgressMethodCallback.builder().method((Method)mcpProgressMethod)).bean(progressObject)).progress(progressAnnotation)).build();
            return new SyncProgressSpecification(progressAnnotation.clients(), methodCallback);
        }).toList()).flatMap(Collection::stream).toList();
        return progressConsumers;
    }

    protected Method[] doGetClassMethods(Object bean) {
        return bean.getClass().getDeclaredMethods();
    }
}

