/*
 * Decompiled with CFR 0.152.
 */
package org.spiffyui.build;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GzipListUtil {
    private GzipListUtil() {
    }

    public static void zipFileList(List<File> files, File destinationDir) throws IOException {
        for (File source : files) {
            File dest = new File(destinationDir, source.getName() + ".gz");
            GzipListUtil.zipFile(source, dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipFile(File source, File dest) throws IOException {
        FileInputStream in = new FileInputStream(source);
        BufferedInputStream in2 = new BufferedInputStream(in);
        FileOutputStream out = new FileOutputStream(dest);
        GZIPOutputStream zipOut = new GZIPOutputStream(out);
        BufferedOutputStream out2 = new BufferedOutputStream(zipOut);
        try {
            int chunk;
            while ((chunk = in2.read()) != -1) {
                out2.write(chunk);
            }
        }
        finally {
            if (out2 != null) {
                out2.close();
            }
            if (zipOut != null) {
                out2.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

