/*
 * Decompiled with CFR 0.152.
 */
package org.spiffyui.build;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Resources;
import org.apache.tools.ant.types.resources.Restrict;
import org.apache.tools.ant.types.resources.selectors.Exists;
import org.apache.tools.ant.types.resources.selectors.Not;
import org.apache.tools.ant.types.resources.selectors.ResourceSelector;
import org.apache.tools.ant.util.FileUtils;
import org.spiffyui.build.GzipListUtil;

public class GzipListTask
extends Task {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private static final ResourceSelector EXISTS = new Exists();
    private static final ResourceSelector NOT_EXISTS = new Not(EXISTS);
    private File m_destinationDir;
    private ResourceCollection m_rc;

    public void addFileset(FileSet set) {
        this.add((ResourceCollection)set);
    }

    public void addFilelist(FileList list) {
        this.add((ResourceCollection)list);
    }

    public void setDest(File dir) {
        this.m_destinationDir = dir;
    }

    public synchronized void add(ResourceCollection c) {
        if (this.m_rc == null) {
            this.m_rc = c;
            return;
        }
        if (!(this.m_rc instanceof Resources)) {
            Resources newRc = new Resources();
            newRc.setProject(this.getProject());
            newRc.add(this.m_rc);
            this.m_rc = newRc;
        }
        ((Resources)this.m_rc).add(c);
    }

    private ResourceCollection getResources() {
        if (this.m_rc == null) {
            return null;
        }
        Restrict noexistRc = new Restrict();
        noexistRc.add(NOT_EXISTS);
        noexistRc.add(this.m_rc);
        Iterator i = noexistRc.iterator();
        while (i.hasNext()) {
            this.log(i.next() + " does not exist.", 0);
        }
        if (this.m_destinationDir != null) {
            for (Object o : this.m_rc) {
                File f;
                if (!(o instanceof FileResource) || !FILE_UTILS.fileNameEquals(f = ((FileResource)o).getFile(), this.m_destinationDir)) continue;
                throw new BuildException("Input file \"" + f + "\" is the same as the output directory.");
            }
        }
        Restrict result = new Restrict();
        result.add(EXISTS);
        result.add(this.m_rc);
        return result;
    }

    public void reset() {
        this.m_rc = null;
        this.m_destinationDir = null;
    }

    public void execute() throws BuildException {
        if (this.m_destinationDir == null) {
            throw new BuildException("Must specify an output directory");
        }
        if (this.getResources() == null) {
            return;
        }
        ResourceCollection rc = this.getResources();
        Iterator i = rc.iterator();
        ArrayList<File> files = new ArrayList<File>();
        try {
            while (i.hasNext()) {
                files.add(((FileResource)i.next()).getFile());
            }
            GzipListUtil.zipFileList(files, this.m_destinationDir);
        }
        catch (IOException ioe) {
            throw new BuildException("Unable to GZIP file list", (Throwable)ioe);
        }
    }
}

