/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.tools.dbms;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.specrunner.tools.dbms.ConnectionInfo;
import schemacrawler.schema.Database;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoLevel;
import schemacrawler.utility.SchemaCrawlerUtility;

public class ConnectionDatabase {
    private Connection connection;
    private Database database;

    public ConnectionDatabase(ConnectionInfo ci) throws Exception {
        SchemaCrawlerOptions options = new SchemaCrawlerOptions();
        this.prepareOptions(options, ci);
        Class.forName(ci.getDriver());
        this.connection = DriverManager.getConnection(ci.getUrl(), ci.getUser(), ci.getPassword());
        this.database = SchemaCrawlerUtility.getDatabase((Connection)this.connection, (SchemaCrawlerOptions)options);
    }

    protected void prepareOptions(SchemaCrawlerOptions options, final ConnectionInfo ci) {
        options.setSchemaInclusionRule(new InclusionRule(){

            public boolean include(String text) {
                return text.equalsIgnoreCase(ci.getSchema());
            }
        });
        options.setSchemaInfoLevel(SchemaInfoLevel.standard());
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void finalize() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

