/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.tools.dbms;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.specrunner.tools.dbms.BaseComparator;
import org.specrunner.tools.dbms.ConfigurationFiles;
import org.specrunner.tools.dbms.ConnectionDatabase;
import org.specrunner.tools.dbms.ConnectionInfo;
import org.specrunner.tools.dbms.IPart;
import org.specrunner.tools.dbms.Pair;
import org.specrunner.tools.dbms.core.PairingDefault;
import org.specrunner.tools.dbms.listeners.IColumnListener;
import org.specrunner.tools.dbms.listeners.ITableListener;
import schemacrawler.schema.Column;
import schemacrawler.schema.Database;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;

public abstract class AbstractBaseTool {
    protected String getDate() {
        return new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS").format(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String process(String msg, ConnectionInfo old, ConnectionInfo current, ConfigurationFiles fileTableListeners, ConfigurationFiles fileColumnListeners) throws Exception {
        ConnectionDatabase pairOld = null;
        ConnectionDatabase pairCurrent = null;
        try {
            pairOld = this.newConnectionDatabase(old);
            Database databaseOld = pairOld.getDatabase();
            pairCurrent = this.newConnectionDatabase(current);
            Database databaseCurrent = pairCurrent.getDatabase();
            StringBuilder sb = this.process(databaseOld, databaseOld.getSchema(old.getSchema()), databaseCurrent, databaseCurrent.getSchema(current.getSchema()), fileTableListeners, fileColumnListeners);
            if (sb.length() > 0) {
                String string = sb.toString();
                return string;
            }
            String string = msg;
            return string;
        }
        finally {
            if (pairOld != null) {
                pairOld.finalize();
            }
            if (pairCurrent != null) {
                pairCurrent.finalize();
            }
        }
    }

    protected ConnectionDatabase newConnectionDatabase(ConnectionInfo ci) throws Exception {
        return new ConnectionDatabase(ci);
    }

    protected StringBuilder process(Database database1, Schema schema1, Database database2, Schema schema2, ConfigurationFiles fileTableListeners, ConfigurationFiles fileColumnListeners) {
        List<ITableListener> tableListeners = this.getTableListeners(fileTableListeners);
        List<IColumnListener> columnListeners = this.getColumnListeners(fileColumnListeners);
        Iterable<Pair<Table>> tables = new PairingDefault<Table>().pair(this.children(database1, schema1), this.children(database2, schema2), this.comparatorTable());
        Iterator<Pair<Table>> iterTables = tables.iterator();
        StringBuilder report = new StringBuilder();
        while (iterTables.hasNext()) {
            StringBuilder sbTable = new StringBuilder();
            boolean showTable = false;
            Pair<Table> table = iterTables.next();
            for (ITableListener lis : tableListeners) {
                IPart p = lis.process(table);
                if (!p.hasData()) continue;
                showTable = showTable || p.isMandatory();
                sbTable.append(p.getData());
            }
            Iterable<Pair<Column>> columns = new PairingDefault<Column>().pair(this.children(schema1, table.getOld()), this.children(schema2, table.getCurrent()), this.comparatorColumn());
            Iterator<Pair<Column>> iterColumns = columns.iterator();
            StringBuilder sbColumns = new StringBuilder();
            boolean showColumns = false;
            while (iterColumns.hasNext()) {
                StringBuilder sbColumn = new StringBuilder();
                boolean showColumn = false;
                Pair<Column> column = iterColumns.next();
                for (IColumnListener lis : columnListeners) {
                    IPart p = lis.process(column);
                    if (!p.hasData()) continue;
                    showColumn = showColumn || p.isMandatory();
                    sbColumn.append(p.getData());
                }
                if (!showColumn) continue;
                sbColumns.append((CharSequence)sbColumn);
                showColumns = true;
            }
            if (showTable || showColumns) {
                report.append('\n');
                report.append((CharSequence)sbTable);
            }
            if (!showColumns) continue;
            report.append((CharSequence)sbColumns);
        }
        return report;
    }

    protected List<ITableListener> getTableListeners(ConfigurationFiles fileTableListeners) {
        return this.load(ITableListener.class, fileTableListeners);
    }

    protected List<IColumnListener> getColumnListeners(ConfigurationFiles fileColumnListeners) {
        return this.load(IColumnListener.class, fileColumnListeners);
    }

    protected <T> List<T> load(Class<T> type, ConfigurationFiles files) {
        LinkedList result = new LinkedList();
        for (String file : files) {
            InputStream in = null;
            BufferedReader br = null;
            InputStreamReader fr = null;
            try {
                String input;
                File f = new File(file);
                if (!f.exists()) {
                    in = BaseComparator.class.getResourceAsStream(file);
                    if (in == null) {
                        throw new RuntimeException("Invalid configuration file (" + type + "): " + file);
                    }
                } else {
                    in = new FileInputStream(f);
                }
                fr = new InputStreamReader(in);
                br = new BufferedReader(fr);
                while ((input = br.readLine()) != null) {
                    result.add(Class.forName(input.trim()).newInstance());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (br == null) continue;
                try {
                    br.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return result;
    }

    protected List<Table> children(Database database, Schema schema) {
        if (database == null || schema == null) {
            return new LinkedList<Table>();
        }
        LinkedList<Table> tables = new LinkedList<Table>(database.getTables(schema));
        Collections.sort(tables, this.comparatorTable());
        return tables;
    }

    protected Comparator<Table> comparatorTable() {
        return new Comparator<Table>(){

            @Override
            public int compare(Table o1, Table o2) {
                return o1 == null ? (o2 == null ? 0 : 1) : (o2 == null ? -1 : o1.getName().compareToIgnoreCase(o2.getName()));
            }
        };
    }

    protected List<Column> children(Schema schema, Table table) {
        if (schema == null || table == null) {
            return new LinkedList<Column>();
        }
        List columns = table.getColumns();
        Collections.sort(columns, this.comparatorColumn());
        return columns;
    }

    protected Comparator<Column> comparatorColumn() {
        return new Comparator<Column>(){

            @Override
            public int compare(Column o1, Column o2) {
                return o1 == null ? (o2 == null ? 0 : 1) : (o2 == null ? -1 : o1.getName().compareToIgnoreCase(o2.getName()));
            }
        };
    }
}

