/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal.predicates;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.predicates.AbstractFilePredicate;
import org.sonar.api.scan.filesystem.PathResolver;

class URIPredicate
extends AbstractFilePredicate {
    private final URI uri;
    private final Path baseDir;

    URIPredicate(URI uri, Path baseDir) {
        this.baseDir = baseDir;
        this.uri = uri;
    }

    public boolean apply(InputFile f) {
        return this.uri.equals(f.uri());
    }

    @Override
    public Iterable<InputFile> get(FileSystem.Index index) {
        Path path = Paths.get(this.uri);
        Optional relative = PathResolver.relativize((Path)this.baseDir, (Path)path);
        if (!relative.isPresent()) {
            return Collections.emptyList();
        }
        InputFile f = index.inputFile((String)relative.get());
        return f != null ? Arrays.asList(f) : Collections.emptyList();
    }

    @Override
    public int priority() {
        return 20;
    }
}

