/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal.predicates;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.PathPattern;
import org.sonar.api.batch.fs.internal.predicates.AbsolutePathPredicate;
import org.sonar.api.batch.fs.internal.predicates.AndPredicate;
import org.sonar.api.batch.fs.internal.predicates.FalsePredicate;
import org.sonar.api.batch.fs.internal.predicates.FileExtensionPredicate;
import org.sonar.api.batch.fs.internal.predicates.FilenamePredicate;
import org.sonar.api.batch.fs.internal.predicates.LanguagePredicate;
import org.sonar.api.batch.fs.internal.predicates.NotPredicate;
import org.sonar.api.batch.fs.internal.predicates.OrPredicate;
import org.sonar.api.batch.fs.internal.predicates.PathPatternPredicate;
import org.sonar.api.batch.fs.internal.predicates.RelativePathPredicate;
import org.sonar.api.batch.fs.internal.predicates.StatusPredicate;
import org.sonar.api.batch.fs.internal.predicates.TruePredicate;
import org.sonar.api.batch.fs.internal.predicates.TypePredicate;
import org.sonar.api.batch.fs.internal.predicates.URIPredicate;

public class DefaultFilePredicates
implements FilePredicates {
    private final Path baseDir;

    public DefaultFilePredicates(Path baseDir) {
        this.baseDir = baseDir;
    }

    public FilePredicate all() {
        return TruePredicate.TRUE;
    }

    public FilePredicate none() {
        return FalsePredicate.FALSE;
    }

    public FilePredicate hasAbsolutePath(String s) {
        return new AbsolutePathPredicate(s, this.baseDir);
    }

    public FilePredicate hasRelativePath(String s) {
        return new RelativePathPredicate(s);
    }

    public FilePredicate hasFilename(String s) {
        return new FilenamePredicate(s);
    }

    public FilePredicate hasExtension(String s) {
        return new FileExtensionPredicate(s);
    }

    public FilePredicate hasURI(URI uri) {
        return new URIPredicate(uri, this.baseDir);
    }

    public FilePredicate matchesPathPattern(String inclusionPattern) {
        return new PathPatternPredicate(PathPattern.create(inclusionPattern));
    }

    public FilePredicate matchesPathPatterns(String[] inclusionPatterns) {
        if (inclusionPatterns.length == 0) {
            return TruePredicate.TRUE;
        }
        FilePredicate[] predicates = new FilePredicate[inclusionPatterns.length];
        for (int i = 0; i < inclusionPatterns.length; ++i) {
            predicates[i] = new PathPatternPredicate(PathPattern.create(inclusionPatterns[i]));
        }
        return this.or(predicates);
    }

    public FilePredicate doesNotMatchPathPattern(String exclusionPattern) {
        return this.not(this.matchesPathPattern(exclusionPattern));
    }

    public FilePredicate doesNotMatchPathPatterns(String[] exclusionPatterns) {
        if (exclusionPatterns.length == 0) {
            return TruePredicate.TRUE;
        }
        return this.not(this.matchesPathPatterns(exclusionPatterns));
    }

    public FilePredicate hasPath(String s) {
        File file = new File(s);
        if (file.isAbsolute()) {
            return this.hasAbsolutePath(s);
        }
        return this.hasRelativePath(s);
    }

    public FilePredicate is(File ioFile) {
        if (ioFile.isAbsolute()) {
            return this.hasAbsolutePath(ioFile.getAbsolutePath());
        }
        return this.hasRelativePath(ioFile.getPath());
    }

    public FilePredicate hasLanguage(String language) {
        return new LanguagePredicate(language);
    }

    public FilePredicate hasLanguages(Collection<String> languages) {
        ArrayList<FilePredicate> list = new ArrayList<FilePredicate>();
        for (String language : languages) {
            list.add(this.hasLanguage(language));
        }
        return this.or(list);
    }

    public FilePredicate hasLanguages(String ... languages) {
        ArrayList<FilePredicate> list = new ArrayList<FilePredicate>();
        for (String language : languages) {
            list.add(this.hasLanguage(language));
        }
        return this.or(list);
    }

    public FilePredicate hasType(InputFile.Type type) {
        return new TypePredicate(type);
    }

    public FilePredicate not(FilePredicate p) {
        return new NotPredicate(p);
    }

    public FilePredicate or(Collection<FilePredicate> or) {
        return OrPredicate.create(or);
    }

    public FilePredicate or(FilePredicate ... or) {
        return OrPredicate.create(Arrays.asList(or));
    }

    public FilePredicate or(FilePredicate first, FilePredicate second) {
        return OrPredicate.create(Arrays.asList(first, second));
    }

    public FilePredicate and(Collection<FilePredicate> and) {
        return AndPredicate.create(and);
    }

    public FilePredicate and(FilePredicate ... and) {
        return AndPredicate.create(Arrays.asList(and));
    }

    public FilePredicate and(FilePredicate first, FilePredicate second) {
        return AndPredicate.create(Arrays.asList(first, second));
    }

    public FilePredicate hasStatus(InputFile.Status status) {
        return new StatusPredicate(status);
    }

    public FilePredicate hasAnyStatus() {
        return new StatusPredicate(null);
    }
}

