/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal.facade;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonarsource.scanner.lib.ScannerEngineFacade;
import org.sonarsource.scanner.lib.internal.facade.Dirs;
import org.sonarsource.scanner.lib.internal.facade.forked.JreCacheHit;

public abstract class AbstractScannerEngineFacade
implements ScannerEngineFacade {
    private final Map<String, String> bootstrapProperties;
    private final boolean isSonarQubeCloud;
    private final String serverVersion;
    private final Boolean didEngineCacheHit;
    private final JreCacheHit jreCacheHit;

    protected AbstractScannerEngineFacade(Map<String, String> bootstrapProperties, boolean isSonarQubeCloud, @Nullable String serverVersion, @Nullable Boolean didEngineCacheHit, @Nullable JreCacheHit jreCacheHit) {
        this.bootstrapProperties = bootstrapProperties;
        this.isSonarQubeCloud = isSonarQubeCloud;
        this.serverVersion = serverVersion;
        this.didEngineCacheHit = didEngineCacheHit;
        this.jreCacheHit = jreCacheHit;
    }

    @Override
    public String getServerVersion() {
        if (this.isSonarQubeCloud) {
            throw new UnsupportedOperationException("Server version is not available for SonarQube Cloud.");
        }
        return this.serverVersion;
    }

    @Override
    public boolean isSonarQubeCloud() {
        return this.isSonarQubeCloud;
    }

    @Override
    public boolean analyze(Map<String, String> analysisProps) {
        HashMap<String, String> allProps = new HashMap<String, String>();
        allProps.putAll(this.bootstrapProperties);
        allProps.putAll(analysisProps);
        AbstractScannerEngineFacade.initAnalysisProperties(allProps);
        this.addStatsProperties(allProps);
        return this.doAnalyze(allProps);
    }

    private void addStatsProperties(Map<String, String> allProps) {
        if (this.jreCacheHit != null) {
            allProps.put("sonar.scanner.wasJreCacheHit", this.jreCacheHit.name());
        }
        if (this.didEngineCacheHit != null) {
            allProps.put("sonar.scanner.wasEngineCacheHit", String.valueOf(this.didEngineCacheHit));
        }
    }

    protected abstract boolean doAnalyze(Map<String, String> var1);

    private static void initAnalysisProperties(Map<String, String> p) {
        new Dirs().init(p);
    }

    @Override
    public Map<String, String> getBootstrapProperties() {
        return this.bootstrapProperties;
    }
}

