/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.ast;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonarsource.analyzer.commons.regex.ast.SourceCharacter;

public class FlagSet {
    private int mask;
    private final Map<Integer, SourceCharacter> flagCharacters;

    public FlagSet() {
        this(0);
    }

    public FlagSet(FlagSet other) {
        this.mask = other.mask;
        this.flagCharacters = new HashMap<Integer, SourceCharacter>(other.flagCharacters);
    }

    public FlagSet(int initialFlags) {
        this.flagCharacters = new HashMap<Integer, SourceCharacter>();
        this.mask = 0;
        this.add(initialFlags);
    }

    public boolean contains(int flag) {
        return (this.mask & flag) != 0;
    }

    @CheckForNull
    public SourceCharacter getJavaCharacterForFlag(int flag) {
        return this.flagCharacters.get(flag);
    }

    public void add(int flag) {
        if ((flag & 0x100) != 0) {
            this.mask |= 0x40;
        }
        this.mask |= flag;
    }

    public void add(int flag, SourceCharacter character) {
        this.add(flag);
        this.flagCharacters.put(flag, character);
    }

    public void addAll(FlagSet other) {
        this.mask |= other.mask;
        this.flagCharacters.putAll(other.flagCharacters);
    }

    public void removeAll(FlagSet other) {
        this.mask &= ~other.mask;
        this.flagCharacters.keySet().removeAll(other.flagCharacters.keySet());
    }

    public int getMask() {
        return this.mask;
    }

    public boolean isEmpty() {
        return this.mask == 0;
    }
}

