/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex;

import java.util.Set;
import org.sonarsource.analyzer.commons.regex.CharacterParser;
import org.sonarsource.analyzer.commons.regex.RegexFeature;
import org.sonarsource.analyzer.commons.regex.RegexLexer;
import org.sonarsource.analyzer.commons.regex.ast.IndexRange;

public abstract class RegexSource {
    protected final String source;

    protected RegexSource(String source) {
        this.source = source;
    }

    public String getSourceText() {
        return this.source;
    }

    public String substringAt(IndexRange range) {
        return this.getSourceText().substring(range.getBeginningOffset(), Math.min(range.getEndingOffset(), this.length()));
    }

    public int length() {
        return this.getSourceText().length();
    }

    public abstract CharacterParser createCharacterParser();

    public RegexLexer createLexer() {
        return new RegexLexer(this, this.createCharacterParser());
    }

    public abstract Set<RegexFeature> features();

    public boolean supportsFeature(RegexFeature feature) {
        return this.features().contains((Object)feature);
    }
}

