/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.vm;

import org.sonar.sslr.internal.vm.CompilationHandler;
import org.sonar.sslr.internal.vm.Instruction;
import org.sonar.sslr.internal.vm.ParsingExpression;

public class OneOrMoreExpression
implements ParsingExpression {
    private final ParsingExpression subExpression;

    public OneOrMoreExpression(ParsingExpression subExpression) {
        this.subExpression = subExpression;
    }

    @Override
    public Instruction[] compile(CompilationHandler compiler) {
        Instruction[] sub = compiler.compile(this.subExpression);
        Instruction[] result = new Instruction[sub.length + 5];
        result[0] = Instruction.choice(sub.length + 4);
        System.arraycopy(sub, 0, result, 1, sub.length);
        result[sub.length + 1] = Instruction.commitVerify(1);
        result[sub.length + 2] = Instruction.choice(3);
        result[sub.length + 3] = Instruction.jump(-2 - sub.length);
        result[sub.length + 4] = Instruction.backtrack();
        return result;
    }

    public String toString() {
        return "OneOrMore[" + this.subExpression + "]";
    }
}

