/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.tree.PyTree;
import org.sonar.python.types.InferredTypes;

public class StringLiteralImpl
extends PyTree
implements StringLiteral {
    private final List<StringElement> stringElements;
    private static final Set<String> BYTES_PREFIXES = new HashSet<String>(Arrays.asList("b", "B", "br", "Br", "bR", "BR", "rb", "rB", "Rb", "RB"));

    StringLiteralImpl(List<StringElement> stringElements) {
        this.stringElements = stringElements;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.STRING_LITERAL;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitStringLiteral(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Collections.unmodifiableList(this.stringElements);
    }

    @Override
    public List<StringElement> stringElements() {
        return this.stringElements;
    }

    @Override
    public String trimmedQuotesValue() {
        return this.stringElements().stream().map(StringElement::trimmedQuotesValue).collect(Collectors.joining());
    }

    @Override
    public InferredType type() {
        if (this.stringElements.size() == 1 && BYTES_PREFIXES.contains(this.stringElements.get(0).prefix())) {
            return InferredTypes.anyType();
        }
        return InferredTypes.STR;
    }
}

