/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.ElseClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class ForStatementImpl
extends PyTree
implements ForStatement {
    private final Token forKeyword;
    private final List<Expression> expressions;
    private final Token inKeyword;
    private final List<Expression> testExpressions;
    private final Token colon;
    private final Token firstNewLine;
    private final Token firstIndent;
    private final StatementList body;
    private final Token firstDedent;
    private final ElseClause elseClause;
    private final Token asyncKeyword;
    private final boolean isAsync;

    public ForStatementImpl(Token forKeyword, List<Expression> expressions, Token inKeyword, List<Expression> testExpressions, Token colon, @Nullable Token firstNewLine, @Nullable Token firstIndent, StatementList body, @Nullable Token firstDedent, @Nullable ElseClause elseClause, @Nullable Token asyncKeyword) {
        this.forKeyword = forKeyword;
        this.expressions = expressions;
        this.inKeyword = inKeyword;
        this.testExpressions = testExpressions;
        this.colon = colon;
        this.firstNewLine = firstNewLine;
        this.firstIndent = firstIndent;
        this.body = body;
        this.firstDedent = firstDedent;
        this.elseClause = elseClause;
        this.asyncKeyword = asyncKeyword;
        this.isAsync = asyncKeyword != null;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.FOR_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitForStatement(this);
    }

    @Override
    public Token forKeyword() {
        return this.forKeyword;
    }

    @Override
    public List<Expression> expressions() {
        return this.expressions;
    }

    @Override
    public Token inKeyword() {
        return this.inKeyword;
    }

    @Override
    public List<Expression> testExpressions() {
        return this.testExpressions;
    }

    @Override
    public Token colon() {
        return this.colon;
    }

    @Override
    public StatementList body() {
        return this.body;
    }

    @Override
    @CheckForNull
    public ElseClause elseClause() {
        return this.elseClause;
    }

    @Override
    public boolean isAsync() {
        return this.isAsync;
    }

    @Override
    @CheckForNull
    public Token asyncKeyword() {
        return this.asyncKeyword;
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(Arrays.asList(this.asyncKeyword, this.forKeyword), this.expressions, Collections.singletonList(this.inKeyword), this.testExpressions, Arrays.asList(this.colon, this.firstNewLine, this.firstIndent, this.body, this.firstDedent, this.elseClause)).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

