/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.symbols.AmbiguousSymbol;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.python.index.ClassDescriptor;
import org.sonar.python.semantic.AmbiguousSymbolImpl;
import org.sonar.python.semantic.FunctionSymbolImpl;
import org.sonar.python.semantic.SymbolImpl;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.TypeShed;
import org.sonar.python.types.protobuf.SymbolsProtos;

public class ClassSymbolImpl
extends SymbolImpl
implements ClassSymbol {
    private final List<Symbol> superClasses = new ArrayList<Symbol>();
    private List<String> superClassesFqns = new ArrayList<String>();
    private List<String> inlinedSuperClassFqn = new ArrayList<String>();
    private Set<Symbol> allSuperClasses = null;
    private Set<Symbol> allSuperClassesIncludingAmbiguousSymbols = null;
    private boolean hasSuperClassWithoutSymbol = false;
    private final Set<Symbol> members = new HashSet<Symbol>();
    private Map<String, Symbol> membersByName = null;
    private boolean hasAlreadyReadSuperClasses = false;
    private boolean hasAlreadyReadMembers = false;
    private boolean hasDecorators = false;
    private boolean hasMetaClass = false;
    private final LocationInFile classDefinitionLocation;
    @Nullable
    private String metaclassFQN = null;
    private boolean supportsGenerics = false;

    public ClassSymbolImpl(ClassDef classDef, @Nullable String fullyQualifiedName, PythonFile pythonFile) {
        super(classDef.name().name(), fullyQualifiedName);
        this.setKind(Symbol.Kind.CLASS);
        Path path = SymbolUtils.pathOf(pythonFile);
        String fileId = path != null ? path.toString() : pythonFile.toString();
        this.hasDecorators = !classDef.decorators().isEmpty();
        this.classDefinitionLocation = TreeUtils.locationInFile(classDef.name(), fileId);
    }

    public ClassSymbolImpl(String name, @Nullable String fullyQualifiedName) {
        super(name, fullyQualifiedName);
        this.classDefinitionLocation = null;
        this.hasDecorators = false;
        this.hasMetaClass = false;
        this.metaclassFQN = null;
        this.supportsGenerics = false;
        this.setKind(Symbol.Kind.CLASS);
    }

    public ClassSymbolImpl(String name, @Nullable String fullyQualifiedName, LocationInFile location) {
        super(name, fullyQualifiedName);
        this.classDefinitionLocation = location;
        this.hasDecorators = false;
        this.hasMetaClass = false;
        this.metaclassFQN = null;
        this.supportsGenerics = false;
        this.setKind(Symbol.Kind.CLASS);
    }

    public ClassSymbolImpl(ClassDescriptor classDescriptor, String symbolName) {
        super(symbolName, classDescriptor.fullyQualifiedName());
        this.setKind(Symbol.Kind.CLASS);
        this.classDefinitionLocation = classDescriptor.definitionLocation();
        this.hasDecorators = classDescriptor.hasDecorators();
        this.hasMetaClass = classDescriptor.hasMetaClass();
        this.metaclassFQN = classDescriptor.metaclassFQN();
        this.supportsGenerics = classDescriptor.supportsGenerics();
        this.hasSuperClassWithoutSymbol = classDescriptor.hasSuperClassWithoutDescriptor();
    }

    public static ClassSymbol copyFrom(String name, ClassSymbol classSymbol) {
        return new ClassSymbolImpl(name, classSymbol);
    }

    private ClassSymbolImpl(String name, ClassSymbol classSymbol) {
        super(name, classSymbol.fullyQualifiedName());
        this.classDefinitionLocation = classSymbol.definitionLocation();
        this.hasDecorators = classSymbol.hasDecorators();
        this.hasMetaClass = ((ClassSymbolImpl)classSymbol).hasMetaClass();
        this.metaclassFQN = ((ClassSymbolImpl)classSymbol).metaclassFQN;
        this.supportsGenerics = ((ClassSymbolImpl)classSymbol).supportsGenerics;
        this.validForPythonVersions = ((ClassSymbolImpl)classSymbol).validForPythonVersions;
        this.superClassesFqns = ((ClassSymbolImpl)classSymbol).superClassesFqns;
        this.setKind(Symbol.Kind.CLASS);
    }

    public ClassSymbolImpl(SymbolsProtos.ClassSymbol classSymbolProto, String moduleName) {
        super(classSymbolProto.getName(), TypeShed.normalizedFqn(classSymbolProto.getFullyQualifiedName(), moduleName, classSymbolProto.getName()));
        this.setKind(Symbol.Kind.CLASS);
        this.classDefinitionLocation = null;
        this.hasDecorators = classSymbolProto.getHasDecorators();
        this.hasMetaClass = classSymbolProto.getHasMetaclass();
        this.metaclassFQN = classSymbolProto.getMetaclassName();
        this.supportsGenerics = classSymbolProto.getIsGeneric();
        HashSet<Symbol> classMembers = new HashSet<Symbol>();
        HashMap<String, Set<Object>> descriptorsByFqn = new HashMap<String, Set<Object>>();
        classSymbolProto.getMethodsList().stream().filter(d -> TypeShed.isValidForProjectPythonVersion(d.getValidForList())).forEach(proto -> descriptorsByFqn.computeIfAbsent(proto.getFullyQualifiedName(), d -> new HashSet()).add(proto));
        classSymbolProto.getOverloadedMethodsList().stream().filter(d -> TypeShed.isValidForProjectPythonVersion(d.getValidForList())).forEach(proto -> descriptorsByFqn.computeIfAbsent(proto.getFullname(), d -> new HashSet()).add(proto));
        classSymbolProto.getAttributesList().stream().filter(d -> TypeShed.isValidForProjectPythonVersion(d.getValidForList())).forEach(proto -> descriptorsByFqn.computeIfAbsent(proto.getFullyQualifiedName(), d -> new HashSet()).add(proto));
        this.inlineInheritedMethodsFromPrivateClass(classSymbolProto.getSuperClassesList(), descriptorsByFqn);
        for (Map.Entry entry : descriptorsByFqn.entrySet()) {
            Set<Symbol> symbols = TypeShed.symbolsFromProtobufDescriptors((Set)entry.getValue(), this.fullyQualifiedName, moduleName);
            classMembers.add(symbols.size() > 1 ? AmbiguousSymbolImpl.create(symbols) : symbols.iterator().next());
        }
        this.addMembers(classMembers);
        this.superClassesFqns.addAll(classSymbolProto.getSuperClassesList().stream().map(TypeShed::normalizedFqn).collect(Collectors.toList()));
        this.superClassesFqns.removeAll(this.inlinedSuperClassFqn);
        this.validForPythonVersions = new HashSet<String>(classSymbolProto.getValidForList());
    }

    private void inlineInheritedMethodsFromPrivateClass(List<String> superClassesFqns, Map<String, Set<Object>> descriptorsByFqn) {
        for (String superClassFqn : superClassesFqns) {
            String methodFqn;
            if (!SymbolUtils.isPrivateName(superClassFqn)) continue;
            SymbolsProtos.ClassSymbol superClass = TypeShed.classDescriptorWithFQN(superClassFqn);
            if (superClass == null) {
                return;
            }
            this.inlinedSuperClassFqn.add(superClassFqn);
            for (SymbolsProtos.FunctionSymbol functionSymbol : superClass.getMethodsList()) {
                methodFqn = this.fullyQualifiedName + "." + functionSymbol.getName();
                descriptorsByFqn.computeIfAbsent(methodFqn, d -> new HashSet()).add(functionSymbol);
            }
            for (SymbolsProtos.OverloadedFunctionSymbol overloadedFunctionSymbol : superClass.getOverloadedMethodsList()) {
                methodFqn = this.fullyQualifiedName + "." + overloadedFunctionSymbol.getName();
                descriptorsByFqn.computeIfAbsent(methodFqn, d -> new HashSet()).add(overloadedFunctionSymbol);
            }
            this.superClassesFqns.addAll(superClass.getSuperClassesList());
        }
    }

    @Override
    public ClassSymbolImpl copyWithoutUsages() {
        ClassSymbolImpl copiedClassSymbol = new ClassSymbolImpl(this.name(), this);
        if (this.hasEvaluatedSuperClasses()) {
            for (Symbol superClass : this.superClasses()) {
                if (superClass == this) {
                    copiedClassSymbol.superClasses.add(copiedClassSymbol);
                    continue;
                }
                if (superClass.is(Symbol.Kind.CLASS, Symbol.Kind.AMBIGUOUS)) {
                    copiedClassSymbol.superClasses.add(((SymbolImpl)superClass).copyWithoutUsages());
                    continue;
                }
                copiedClassSymbol.superClasses.add(new SymbolImpl(superClass.name(), superClass.fullyQualifiedName()));
            }
        }
        copiedClassSymbol.addMembers(this.members.stream().map(m -> ((SymbolImpl)m).copyWithoutUsages()).collect(Collectors.toList()));
        if (this.hasSuperClassWithoutSymbol) {
            copiedClassSymbol.setHasSuperClassWithoutSymbol();
        }
        return copiedClassSymbol;
    }

    @Override
    public List<Symbol> superClasses() {
        if (!this.hasAlreadyReadSuperClasses && this.superClasses.isEmpty() && !this.superClassesFqns.isEmpty()) {
            this.superClassesFqns.stream().map(SymbolUtils::typeshedSymbolWithFQN).forEach(this::addSuperClass);
        }
        this.hasAlreadyReadSuperClasses = true;
        return Collections.unmodifiableList(this.superClasses);
    }

    public void addSuperClass(Symbol symbol) {
        if (this.hasAlreadyReadSuperClasses) {
            throw new IllegalStateException("Cannot call addSuperClass, super classes were already read");
        }
        this.superClasses.add(symbol);
    }

    @Override
    public boolean hasUnresolvedTypeHierarchy() {
        return this.hasUnresolvedTypeHierarchy(true);
    }

    public boolean hasUnresolvedTypeHierarchy(boolean includeAmbiguousSymbols) {
        for (Symbol superClassSymbol : this.allSuperClasses(includeAmbiguousSymbols)) {
            if (superClassSymbol.kind() != Symbol.Kind.CLASS) {
                return true;
            }
            ClassSymbolImpl superClass = (ClassSymbolImpl)superClassSymbol;
            if (!superClass.hasSuperClassWithoutSymbol) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Symbol> declaredMembers() {
        this.hasAlreadyReadMembers = true;
        return this.members;
    }

    @Override
    public Optional<Symbol> resolveMember(String memberName) {
        for (Symbol symbol : this.allSuperClasses(false)) {
            ClassSymbolImpl classSymbol;
            Symbol matchingMember;
            if (symbol.kind() != Symbol.Kind.CLASS || (matchingMember = (classSymbol = (ClassSymbolImpl)symbol).membersByName().get(memberName)) == null) continue;
            return Optional.of(matchingMember);
        }
        return Optional.empty();
    }

    public boolean hasMetaClass() {
        return this.hasMetaClass || this.membersByName().get("__metaclass__") != null;
    }

    @Override
    public boolean canHaveMember(String memberName) {
        if (this.hasUnresolvedTypeHierarchy() || this.hasSuperClassWithUnknownMetaClass()) {
            return true;
        }
        for (Symbol symbol : this.allSuperClasses(true)) {
            ClassSymbolImpl classSymbol;
            Symbol matchingMember;
            if (symbol.kind() != Symbol.Kind.CLASS || (matchingMember = (classSymbol = (ClassSymbolImpl)symbol).membersByName().get(memberName)) == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasSuperClassWithUnknownMetaClass() {
        for (Symbol symbol : this.allSuperClasses(true)) {
            ClassSymbolImpl superClass;
            if (!symbol.is(Symbol.Kind.CLASS) || !(superClass = (ClassSymbolImpl)symbol).hasMetaClass() || "abc.ABCMeta".equals(superClass.metaclassFQN())) continue;
            return true;
        }
        return false;
    }

    @Override
    public LocationInFile definitionLocation() {
        return this.classDefinitionLocation;
    }

    @Override
    public boolean isOrExtends(String fullyQualifiedClassName) {
        return this.allSuperClasses(false).stream().anyMatch(c -> c.fullyQualifiedName() != null && Objects.equals(fullyQualifiedClassName, c.fullyQualifiedName()));
    }

    @Override
    public boolean isOrExtends(ClassSymbol other) {
        if ("object".equals(other.fullyQualifiedName())) {
            return true;
        }
        return this.allSuperClasses(false).stream().anyMatch(c -> Objects.equals(c.fullyQualifiedName(), other.fullyQualifiedName()));
    }

    @Override
    public boolean canBeOrExtend(String fullyQualifiedClassName) {
        if ("object".equals(fullyQualifiedClassName)) {
            return true;
        }
        return this.allSuperClasses(true).stream().anyMatch(c -> c.fullyQualifiedName() != null && Objects.equals(fullyQualifiedClassName, c.fullyQualifiedName())) || this.hasUnresolvedTypeHierarchy();
    }

    @Override
    public boolean hasDecorators() {
        return this.hasDecorators;
    }

    private Map<String, Symbol> membersByName() {
        if (this.membersByName == null) {
            this.membersByName = this.declaredMembers().stream().collect(Collectors.toMap(Symbol::name, m -> m, (s1, s2) -> s1));
        }
        return this.membersByName;
    }

    public void addMembers(Collection<Symbol> members) {
        if (this.hasAlreadyReadMembers) {
            throw new IllegalStateException("Cannot call addMembers, members were already read");
        }
        this.members.addAll(members);
        members.stream().filter(m -> m.kind() == Symbol.Kind.FUNCTION).forEach(m -> ((FunctionSymbolImpl)m).setOwner(this));
    }

    public void setHasSuperClassWithoutSymbol() {
        this.hasSuperClassWithoutSymbol = true;
    }

    public void setHasMetaClass() {
        this.hasMetaClass = true;
    }

    public void setMetaclassFQN(String metaclassFQN) {
        this.metaclassFQN = metaclassFQN;
    }

    @CheckForNull
    public String metaclassFQN() {
        return this.metaclassFQN;
    }

    private Set<Symbol> allSuperClasses(boolean includeAmbiguousSymbols) {
        if (!includeAmbiguousSymbols) {
            if (this.allSuperClasses == null) {
                this.allSuperClasses = new LinkedHashSet<Symbol>();
                ClassSymbolImpl.exploreSuperClasses(this, this.allSuperClasses, false);
            }
            return this.allSuperClasses;
        }
        if (this.allSuperClassesIncludingAmbiguousSymbols == null) {
            this.allSuperClassesIncludingAmbiguousSymbols = new LinkedHashSet<Symbol>();
            ClassSymbolImpl.exploreSuperClasses(this, this.allSuperClassesIncludingAmbiguousSymbols, true);
        }
        return this.allSuperClassesIncludingAmbiguousSymbols;
    }

    private static void exploreSuperClasses(Symbol symbol, Set<Symbol> set, boolean includeAmbiguousSymbols) {
        block3: {
            block2: {
                if (!symbol.is(Symbol.Kind.AMBIGUOUS) || !includeAmbiguousSymbols) break block2;
                AmbiguousSymbol ambiguousSymbol = (AmbiguousSymbol)symbol;
                for (Symbol alternative : ambiguousSymbol.alternatives()) {
                    ClassSymbolImpl.exploreSuperClasses(alternative, set, true);
                }
                break block3;
            }
            if (!set.add(symbol) || !symbol.is(Symbol.Kind.CLASS)) break block3;
            ClassSymbol classSymbol = (ClassSymbol)symbol;
            for (Symbol superClass : classSymbol.superClasses()) {
                ClassSymbolImpl.exploreSuperClasses(superClass, set, includeAmbiguousSymbols);
            }
        }
    }

    @Override
    public void removeUsages() {
        super.removeUsages();
        this.superClasses.forEach(symbol -> ((SymbolImpl)symbol).removeUsages());
        this.members.forEach(symbol -> ((SymbolImpl)symbol).removeUsages());
    }

    public boolean hasSuperClassWithoutSymbol() {
        return this.hasSuperClassWithoutSymbol;
    }

    public boolean supportsGenerics() {
        return this.supportsGenerics;
    }

    public void setSupportsGenerics(boolean supportsGenerics) {
        this.supportsGenerics = supportsGenerics;
    }

    public boolean hasEvaluatedSuperClasses() {
        return this.hasAlreadyReadSuperClasses || this.superClassesFqns.isEmpty();
    }
}

