/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.quickfix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sonar.python.quickfix.PythonTextEdit;

public class PythonQuickFix {
    private final String description;
    private final List<PythonTextEdit> textEdits;

    private PythonQuickFix(String description, List<PythonTextEdit> textEdits) {
        this.description = description;
        this.textEdits = textEdits;
    }

    public String getDescription() {
        return this.description;
    }

    public List<PythonTextEdit> getTextEdits() {
        return this.textEdits;
    }

    public static Builder newQuickFix(String description) {
        return new Builder(description);
    }

    public static class Builder {
        private final String description;
        private final List<PythonTextEdit> textEdits = new ArrayList<PythonTextEdit>();

        private Builder(String description) {
            this.description = description;
        }

        public Builder addTextEdit(PythonTextEdit ... textEdit) {
            this.textEdits.addAll(Arrays.asList(textEdit));
            return this;
        }

        public PythonQuickFix build() {
            return new PythonQuickFix(this.description, this.textEdits);
        }
    }
}

