/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.regex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.regex.AbstractRegexCheck;
import org.sonar.python.tree.TreeUtils;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.CapturingGroupTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;

@Rule(key="S6328")
public class GroupReplacementCheck
extends AbstractRegexCheck {
    private static final String MESSAGE = "Referencing non-existing group%s: %s.";
    private static final Pattern REFERENCE_PATTERN = Pattern.compile("\\\\(\\d+)|\\\\g<(\\d+)>");

    @Override
    protected Map<String, Integer> lookedUpFunctions() {
        return Collections.singletonMap("re.sub", 4);
    }

    @Override
    public void checkRegex(RegexParseResult regexParseResult, CallExpression regexFunctionCall) {
        GroupFinder groupFinder = new GroupFinder();
        groupFinder.visit(regexParseResult);
        this.checkReplacement(regexFunctionCall, groupFinder.groups);
    }

    private void checkReplacement(CallExpression tree, Set<CapturingGroupTree> groups) {
        RegularArgument regArg = TreeUtils.nthArgumentOrKeyword(1, "replacement", tree.arguments());
        if (regArg == null) {
            return;
        }
        if (regArg.expression().is(Tree.Kind.STRING_LITERAL)) {
            StringLiteral expression = (StringLiteral)regArg.expression();
            List<Integer> references = GroupReplacementCheck.collectReferences(expression.trimmedQuotesValue());
            references.removeIf(reference -> groups.stream().anyMatch(group -> group.getGroupNumber() == reference.intValue()));
            if (!references.isEmpty()) {
                List stringReferences = references.stream().map(String::valueOf).collect(Collectors.toList());
                this.regexContext.addIssue(expression, String.format(MESSAGE, references.size() == 1 ? "" : "s", String.join((CharSequence)", ", stringReferences)));
            }
        }
    }

    private static List<Integer> collectReferences(String replacement) {
        Matcher match = REFERENCE_PATTERN.matcher(replacement);
        ArrayList<Integer> references = new ArrayList<Integer>();
        while (match.find()) {
            Optional.ofNullable(match.group(1)).map(Integer::valueOf).filter(ref -> ref != 0).ifPresent(references::add);
            Optional.ofNullable(match.group(2)).map(Integer::valueOf).filter(ref -> ref != 0).ifPresent(references::add);
        }
        return references;
    }

    static class GroupFinder
    extends RegexBaseVisitor {
        private final Set<CapturingGroupTree> groups = new HashSet<CapturingGroupTree>();

        GroupFinder() {
        }

        @Override
        public void visitCapturingGroup(CapturingGroupTree group) {
            this.groups.add(group);
            super.visitCapturingGroup(group);
        }
    }
}

