/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.HashSet;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S5547")
public class RobustCipherAlgorithmCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Use a strong cipher algorithm.";
    private static final HashSet<String> sensitiveCalleeFqns = new HashSet();

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, subscriptionContext -> {
            String fqn;
            CallExpression callExpr = (CallExpression)subscriptionContext.syntaxNode();
            Symbol calleeSymbol = callExpr.calleeSymbol();
            if (calleeSymbol != null && (fqn = calleeSymbol.fullyQualifiedName()) != null && sensitiveCalleeFqns.contains(fqn)) {
                subscriptionContext.addIssue(callExpr.callee(), MESSAGE);
            }
        });
    }

    static {
        for (String libraryName : Arrays.asList("Cryptodome", "Crypto")) {
            for (String vulnerableMethodName : Arrays.asList("DES", "DES3", "ARC2", "ARC4", "Blowfish")) {
                sensitiveCalleeFqns.add(String.format("%s.Cipher.%s.new", libraryName, vulnerableMethodName));
            }
        }
        for (String methodName : Arrays.asList("TripleDES", "Blowfish", "ARC4", "IDEA")) {
            sensitiveCalleeFqns.add(String.format("cryptography.hazmat.primitives.ciphers.algorithms.%s", methodName));
        }
        sensitiveCalleeFqns.add("pyDes.des");
        sensitiveCalleeFqns.add("pyDes.triple_des");
    }
}

