/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.checks.NonCallableCalled;

@Rule(key="S5756")
public class NonCallableCalledCheck
extends NonCallableCalled {
    @Override
    public boolean isNonCallableType(InferredType type) {
        return !type.canHaveMember("__call__");
    }

    @Override
    public String message(InferredType calleeType, @Nullable String name) {
        if (name != null) {
            return String.format("Fix this call; \"%s\"%s is not callable.", name, NonCallableCalledCheck.addTypeName(calleeType));
        }
        return String.format("Fix this call; this expression%s is not callable.", NonCallableCalledCheck.addTypeName(calleeType));
    }
}

