/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.cfg.CfgBlock;
import org.sonar.plugins.python.api.cfg.CfgBranchingBlock;
import org.sonar.plugins.python.api.cfg.ControlFlowGraph;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.WhileStatement;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S1751")
public class LoopExecutingAtMostOnceCheck
extends PythonSubscriptionCheck {
    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> LoopExecutingAtMostOnceCheck.checkCfg(ControlFlowGraph.build((FunctionDef)ctx.syntaxNode(), ctx.pythonFile()), ctx));
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> LoopExecutingAtMostOnceCheck.checkCfg(ControlFlowGraph.build((FileInput)ctx.syntaxNode(), ctx.pythonFile()), ctx));
    }

    private static void checkCfg(@Nullable ControlFlowGraph cfg, SubscriptionContext ctx) {
        if (cfg == null) {
            return;
        }
        cfg.blocks().stream().filter(CfgBranchingBlock.class::isInstance).map(CfgBranchingBlock.class::cast).filter(b -> b.branchingTree().is(Tree.Kind.WHILE_STMT)).forEach(b -> LoopExecutingAtMostOnceCheck.checkLoop(b, ctx));
    }

    private static void checkLoop(CfgBranchingBlock loopBlock, SubscriptionContext ctx) {
        Tree loop = loopBlock.branchingTree();
        ArrayDeque<CfgBlock> workList = new ArrayDeque<CfgBlock>();
        workList.add(loopBlock.trueSuccessor());
        HashSet<CfgBlock> seen = new HashSet<CfgBlock>();
        ArrayList<Token> jumps = new ArrayList<Token>();
        while (!workList.isEmpty()) {
            CfgBlock b = (CfgBlock)workList.pop();
            if (b.successors().contains(loopBlock)) {
                return;
            }
            if (!seen.add(b)) continue;
            if (b.syntacticSuccessor() != null && !LoopExecutingAtMostOnceCheck.breakOfInnerLoop(b, loopBlock)) {
                jumps.add(b.elements().get(b.elements().size() - 1).firstToken());
            }
            b.successors().stream().filter(succ -> LoopExecutingAtMostOnceCheck.blockInsideLoop(succ, loop)).forEach(workList::push);
        }
        if (TreeUtils.hasDescendant(loop, t -> t.is(Tree.Kind.TRY_STMT))) {
            return;
        }
        PythonCheck.PreciseIssue issue = ctx.addIssue(loop.firstToken(), "Refactor this loop to do more than one iteration.");
        jumps.forEach(j -> issue.secondary((Token)j, "The loop stops here."));
    }

    private static boolean breakOfInnerLoop(CfgBlock block, CfgBranchingBlock loopBlock) {
        WhileStatement loop = (WhileStatement)loopBlock.branchingTree();
        CfgBlock breakTarget = loop.elseClause() == null ? loopBlock.falseSuccessor() : loopBlock.falseSuccessor().successors().iterator().next();
        Tree jumpStatement = block.elements().get(block.elements().size() - 1);
        return jumpStatement.is(Tree.Kind.BREAK_STMT) && block.successors().stream().noneMatch(b -> b == breakTarget);
    }

    private static boolean blockInsideLoop(CfgBlock block, Tree loop) {
        List<Tree> elements = block.elements();
        return elements.isEmpty() || TreeUtils.firstAncestor(elements.get(0), tree -> tree == loop) != null;
    }
}

