/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Trivia;

@Rule(key="S1134")
public class FixmeCommentCheck
extends PythonSubscriptionCheck {
    private static final String FIXME_COMMENT_PATTERN = "^#[ ]*fixme.*";
    private static final String MESSAGE = "Take the required action to fix the issue indicated by this \"FIXME\" comment.";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        Pattern pattern = Pattern.compile(FIXME_COMMENT_PATTERN, 2);
        context.registerSyntaxNodeConsumer(Tree.Kind.TOKEN, ctx -> {
            Token token = (Token)ctx.syntaxNode();
            for (Trivia trivia : token.trivia()) {
                String comment = trivia.value();
                if (!pattern.matcher(comment).matches()) continue;
                ctx.addIssue(trivia.token(), MESSAGE);
            }
        });
    }
}

