/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.InferredTypes;

@Rule(key="S5655")
public class ArgumentTypeCheck
extends PythonSubscriptionCheck {
    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            Symbol calleeSymbol = callExpression.calleeSymbol();
            if (calleeSymbol == null) {
                return;
            }
            Set<Symbol> symbols = SymbolUtils.flattenAmbiguousSymbols(Collections.singleton(calleeSymbol));
            if (symbols.stream().anyMatch(s -> !s.is(Symbol.Kind.FUNCTION))) {
                return;
            }
            IssueToReport issue = new IssueToReport();
            if (symbols.stream().allMatch(symbol -> ArgumentTypeCheck.isNonCompliantFunctionCall(issue, (FunctionSymbol)symbol, callExpression))) {
                List<Argument> args = callExpression.arguments();
                Integer firstArgIndex = issue.nonCompliantArgs.first();
                PythonCheck.PreciseIssue preciseIssue = ctx.addIssue(args.get(firstArgIndex), issue.message);
                issue.nonCompliantArgs.forEach(index -> {
                    if (!index.equals(firstArgIndex)) {
                        preciseIssue.secondary((Tree)args.get((int)index), issue.message);
                    }
                });
                issue.secondaryLocations.forEach(locationInFile -> preciseIssue.secondary((LocationInFile)locationInFile, "Function definition"));
            }
        });
    }

    private static boolean isNonCompliantFunctionCall(IssueToReport issue, FunctionSymbol functionSymbol, CallExpression callExpression) {
        if (functionSymbol.hasVariadicParameter()) {
            return false;
        }
        boolean isStaticCall = callExpression.callee().is(Tree.Kind.NAME) || Optional.of(callExpression.callee()).filter(c -> c.is(Tree.Kind.QUALIFIED_EXPR)).flatMap(q -> TreeUtils.getSymbolFromTree(((QualifiedExpression)q).qualifier()).filter(s -> s.is(Symbol.Kind.CLASS))).isPresent();
        return ArgumentTypeCheck.checkFunctionCall(issue, callExpression, functionSymbol, isStaticCall);
    }

    private static boolean checkFunctionCall(IssueToReport issue, CallExpression callExpression, FunctionSymbol functionSymbol, boolean isStaticCall) {
        boolean isKeyword = false;
        int firstParameterOffset = SymbolUtils.firstParameterOffset(functionSymbol, isStaticCall);
        if (firstParameterOffset < 0) {
            return false;
        }
        boolean hasIncompatibleArgumentType = false;
        for (int i = 0; i < callExpression.arguments().size(); ++i) {
            boolean shouldReport;
            Argument argument = callExpression.arguments().get(i);
            int parameterIndex = i + firstParameterOffset;
            if (parameterIndex >= functionSymbol.parameters().size()) {
                return false;
            }
            if (!argument.is(Tree.Kind.REGULAR_ARGUMENT)) continue;
            RegularArgument regularArgument = (RegularArgument)argument;
            boolean bl = shouldReport = (isKeyword |= regularArgument.keywordArgument() != null) ? ArgumentTypeCheck.shouldReportKeywordArgument(regularArgument, functionSymbol) : ArgumentTypeCheck.shouldReportPositionalArgument(regularArgument, functionSymbol, parameterIndex);
            if (!shouldReport) continue;
            hasIncompatibleArgumentType = true;
            ArgumentTypeCheck.reportIssue(issue, functionSymbol, i);
        }
        return hasIncompatibleArgumentType;
    }

    private static boolean shouldReportPositionalArgument(RegularArgument regularArgument, FunctionSymbol functionSymbol, int index) {
        FunctionSymbol.Parameter functionParameter = functionSymbol.parameters().get(index);
        InferredType argumentType = regularArgument.expression().type();
        InferredType parameterType = functionParameter.declaredType();
        if (parameterType.canOnlyBe("object")) {
            return false;
        }
        return ArgumentTypeCheck.isIncompatibleTypes(argumentType, parameterType);
    }

    private static boolean shouldReportKeywordArgument(RegularArgument regularArgument, FunctionSymbol functionSymbol) {
        Name keywordArgument = regularArgument.keywordArgument();
        InferredType argumentType = regularArgument.expression().type();
        if (keywordArgument == null) {
            return false;
        }
        String keywordName = keywordArgument.name();
        Optional<FunctionSymbol.Parameter> correspondingParameter = functionSymbol.parameters().stream().filter(p -> keywordName.equals(p.name())).findFirst();
        return correspondingParameter.map(c -> {
            InferredType parameterType = c.declaredType();
            return ArgumentTypeCheck.isIncompatibleTypes(argumentType, parameterType);
        }).orElse(false);
    }

    private static void reportIssue(IssueToReport issue, FunctionSymbol functionSymbol, int argumentIndex) {
        issue.nonCompliantArgs.add(argumentIndex);
        issue.message = String.format("Change this argument; Function \"%s\" expects a different type", functionSymbol.name());
        if (functionSymbol.definitionLocation() != null) {
            issue.secondaryLocations.add(functionSymbol.definitionLocation());
        }
    }

    private static boolean isIncompatibleTypes(InferredType argumentType, InferredType parameterType) {
        return (ArgumentTypeCheck.isNotDuckTypeCompatible(argumentType, parameterType) || !argumentType.isCompatibleWith(parameterType) && !ArgumentTypeCheck.couldBeDuckTypeCompatible(argumentType, parameterType)) && !ArgumentTypeCheck.isException(argumentType);
    }

    private static boolean isNotDuckTypeCompatible(InferredType argumentType, InferredType parameterType) {
        String firstBuiltin = ArgumentTypeCheck.matchBuiltinCategory(name -> name.equals(InferredTypes.typeName(argumentType)));
        String secondBuiltin = ArgumentTypeCheck.matchBuiltinCategory(name -> name.equals(InferredTypes.typeName(parameterType)));
        return firstBuiltin != null && secondBuiltin != null && !firstBuiltin.equals(secondBuiltin);
    }

    private static boolean couldBeDuckTypeCompatible(InferredType firstType, InferredType secondType) {
        String firstPossibleBuiltin = ArgumentTypeCheck.matchBuiltinCategory(firstType::canBeOrExtend);
        String secondPossibleBuiltin = ArgumentTypeCheck.matchBuiltinCategory(secondType::canBeOrExtend);
        return firstPossibleBuiltin != null && firstPossibleBuiltin.equals(secondPossibleBuiltin);
    }

    public static String matchBuiltinCategory(Predicate<String> predicate) {
        if (predicate.test("str")) {
            return "str";
        }
        if (predicate.test("int") || predicate.test("float") || predicate.test("complex") || predicate.test("bool")) {
            return "number";
        }
        if (predicate.test("list")) {
            return "list";
        }
        if (predicate.test("set")) {
            return "set";
        }
        if (predicate.test("dict")) {
            return "dict";
        }
        if (predicate.test("tuple")) {
            return "tuple";
        }
        return null;
    }

    private static boolean isException(InferredType inferredType) {
        return inferredType.canBeOrExtend("unittest.mock.Mock");
    }

    private static class IssueToReport {
        SortedSet<Integer> nonCompliantArgs = new TreeSet<Integer>();
        String message;
        final Set<LocationInFile> secondaryLocations = new HashSet<LocationInFile>();

        private IssueToReport() {
        }
    }
}

