/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.indexer;

import java.util.List;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.python.indexer.PythonIndexer;
import org.sonarsource.performance.measure.PerformanceMeasure;

public class SonarQubePythonIndexer
extends PythonIndexer {
    private final List<InputFile> files;
    private static final Logger LOG = Loggers.get(SonarQubePythonIndexer.class);

    public SonarQubePythonIndexer(List<InputFile> files) {
        this.files = files;
    }

    @Override
    public void buildOnce(SensorContext context) {
        this.projectBaseDirAbsolutePath = context.fileSystem().baseDir().getAbsolutePath();
        PerformanceMeasure.Duration duration = PerformanceMeasure.start("ProjectLevelSymbolTable");
        LOG.debug("Input files for indexing: " + this.files);
        PythonIndexer.GlobalSymbolsScanner globalSymbolsStep = new PythonIndexer.GlobalSymbolsScanner(this, context);
        globalSymbolsStep.execute(this.files, context);
        duration.stop();
    }
}

