/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.indexer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.python.indexer.PythonIndexer;
import org.sonarsource.api.sonarlint.SonarLintSide;
import org.sonarsource.sonarlint.plugin.api.module.file.ModuleFileEvent;
import org.sonarsource.sonarlint.plugin.api.module.file.ModuleFileListener;
import org.sonarsource.sonarlint.plugin.api.module.file.ModuleFileSystem;

@SonarLintSide(lifespan="MODULE")
public class SonarLintPythonIndexer
extends PythonIndexer
implements ModuleFileListener {
    private final ModuleFileSystem moduleFileSystem;
    private final Map<String, InputFile> indexedFiles = new HashMap<String, InputFile>();
    private static final Logger LOG = Loggers.get(SonarLintPythonIndexer.class);
    private boolean shouldBuildProjectSymbolTable = true;
    private static final long DEFAULT_MAX_LINES_FOR_INDEXING = 300000L;
    private static final String MAX_LINES_PROPERTY = "sonar.python.sonarlint.indexing.maxlines";

    public SonarLintPythonIndexer(ModuleFileSystem moduleFileSystem) {
        this.moduleFileSystem = moduleFileSystem;
    }

    @Override
    public void buildOnce(SensorContext context) {
        long maxLinesForIndexing;
        if (!this.shouldBuildProjectSymbolTable) {
            return;
        }
        this.projectBaseDirAbsolutePath = context.fileSystem().baseDir().getAbsolutePath();
        this.shouldBuildProjectSymbolTable = false;
        List<InputFile> files = SonarLintPythonIndexer.getInputFiles(this.moduleFileSystem);
        long nLines = files.stream().map(InputFile::lines).mapToLong(Integer::longValue).sum();
        if (nLines > (maxLinesForIndexing = context.config().getLong(MAX_LINES_PROPERTY).orElse(300000L).longValue())) {
            LOG.debug("Project symbol table deactivated due to project size (total number of lines is {}, maximum for indexing is {})", (Object)nLines, (Object)maxLinesForIndexing);
            LOG.debug("Update \"sonar.python.sonarlint.indexing.maxlines\" to set a different limit.");
            return;
        }
        LOG.debug("Input files for indexing: " + files);
        PythonIndexer.GlobalSymbolsScanner globalSymbolsStep = new PythonIndexer.GlobalSymbolsScanner(this, context);
        globalSymbolsStep.execute(files, context);
    }

    @Override
    public InputFile getFileWithId(String fileId) {
        String compare = fileId.replace("\\", "/");
        return this.indexedFiles.getOrDefault(compare, null);
    }

    private static List<InputFile> getInputFiles(ModuleFileSystem moduleFileSystem) {
        ArrayList files = new ArrayList();
        moduleFileSystem.files("py", InputFile.Type.MAIN).forEach(files::add);
        return Collections.unmodifiableList(files);
    }

    @Override
    void addFile(InputFile inputFile) throws IOException {
        super.addFile(inputFile);
        this.indexedFiles.put(inputFile.absolutePath(), inputFile);
    }

    @Override
    void removeFile(InputFile inputFile) {
        super.removeFile(inputFile);
        this.indexedFiles.remove(inputFile.absolutePath());
    }

    public void process(ModuleFileEvent moduleFileEvent) {
        InputFile target = moduleFileEvent.getTarget();
        String language = target.language();
        if (language == null || !language.equals("py")) {
            LOG.debug("Module file event for " + target + " has been ignored because it's not a Python file.");
            return;
        }
        ModuleFileEvent.Type type = moduleFileEvent.getType();
        if (type.equals((Object)ModuleFileEvent.Type.DELETED) || type.equals((Object)ModuleFileEvent.Type.MODIFIED)) {
            this.removeFile(target);
        }
        if (type.equals((Object)ModuleFileEvent.Type.CREATED) || type.equals((Object)ModuleFileEvent.Type.MODIFIED)) {
            try {
                this.addFile(target);
            }
            catch (IOException e) {
                LOG.debug("Failed to load file \"{}\" ({}) to the project symbol table", (Object)target.filename(), (Object)type);
            }
        }
    }
}

