/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.indexer;

import com.sonar.sslr.api.AstNode;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.python.Scanner;
import org.sonar.plugins.python.SonarQubePythonFile;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.python.parser.PythonParser;
import org.sonar.python.semantic.ProjectLevelSymbolTable;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.tree.PythonTreeMaker;

public abstract class PythonIndexer {
    private static final Logger LOG = Loggers.get(PythonIndexer.class);
    protected String projectBaseDirAbsolutePath;
    private final Map<URI, String> packageNames = new HashMap<URI, String>();
    private final PythonParser parser = PythonParser.create();
    private final ProjectLevelSymbolTable projectLevelSymbolTable = new ProjectLevelSymbolTable();

    public ProjectLevelSymbolTable projectLevelSymbolTable() {
        return this.projectLevelSymbolTable;
    }

    public String packageName(InputFile inputFile) {
        return this.packageNames.computeIfAbsent(inputFile.uri(), k -> SymbolUtils.pythonPackageName(inputFile.file(), this.projectBaseDirAbsolutePath));
    }

    void removeFile(InputFile inputFile) {
        String packageName = this.packageNames.get(inputFile.uri());
        if (packageName == null) {
            LOG.debug("Failed to remove file \"{}\" from project-level symbol table (file not indexed)", (Object)inputFile.filename());
            return;
        }
        this.packageNames.remove(inputFile.uri());
        this.projectLevelSymbolTable.removeModule(packageName, inputFile.filename());
    }

    void addFile(InputFile inputFile) throws IOException {
        AstNode astNode = this.parser.parse(inputFile.contents());
        FileInput astRoot = new PythonTreeMaker().fileInput(astNode);
        String packageName = SymbolUtils.pythonPackageName(inputFile.file(), this.projectBaseDirAbsolutePath);
        this.packageNames.put(inputFile.uri(), packageName);
        PythonFile pythonFile = SonarQubePythonFile.create(inputFile);
        this.projectLevelSymbolTable.addModule(astRoot, packageName, pythonFile);
    }

    public abstract void buildOnce(SensorContext var1);

    @CheckForNull
    public InputFile getFileWithId(String fileId) {
        return null;
    }

    class GlobalSymbolsScanner
    extends Scanner {
        protected GlobalSymbolsScanner(SensorContext context) {
            super(context);
        }

        @Override
        protected String name() {
            return "global symbols computation";
        }

        @Override
        protected void scanFile(InputFile inputFile) throws IOException {
            PythonIndexer.this.addFile(inputFile);
        }

        @Override
        protected void processException(Exception e, InputFile file) {
            LOG.debug("Unable to construct project-level symbol table for file: " + file);
            LOG.debug(e.getMessage());
        }
    }
}

