/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import org.sonar.api.Plugin;
import org.sonar.api.PropertyType;
import org.sonar.api.SonarProduct;
import org.sonar.api.SonarRuntime;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.python.Python;
import org.sonar.plugins.python.PythonProfile;
import org.sonar.plugins.python.PythonRuleRepository;
import org.sonar.plugins.python.PythonSensor;
import org.sonar.plugins.python.bandit.BanditRulesDefinition;
import org.sonar.plugins.python.bandit.BanditSensor;
import org.sonar.plugins.python.coverage.PythonCoverageSensor;
import org.sonar.plugins.python.flake8.Flake8RulesDefinition;
import org.sonar.plugins.python.flake8.Flake8Sensor;
import org.sonar.plugins.python.indexer.SonarLintPythonIndexer;
import org.sonar.plugins.python.pylint.PylintRulesDefinition;
import org.sonar.plugins.python.pylint.PylintSensor;
import org.sonar.plugins.python.warnings.AnalysisWarningsWrapper;
import org.sonar.plugins.python.xunit.PythonXUnitSensor;

public class PythonPlugin
implements Plugin {
    private static final String PYTHON_CATEGORY = "Python";
    private static final Logger LOG = Loggers.get(PythonPlugin.class);
    private static final String GENERAL = "General";
    private static final String TEST_AND_COVERAGE = "Tests and Coverage";
    private static final String EXTERNAL_ANALYZERS_CATEGORY = "External Analyzers";
    private static final String DEPRECATED_PREFIX = "DEPRECATED : Use sonar.python.coverage.reportPaths instead. ";
    public static final String FILE_SUFFIXES_KEY = "sonar.python.file.suffixes";

    public void define(Plugin.Context context) {
        context.addExtensions((Object)PropertyDefinition.builder((String)FILE_SUFFIXES_KEY).index(10).name("File Suffixes").description("List of suffixes of Python files to analyze.").multiValues(true).category(PYTHON_CATEGORY).subCategory(GENERAL).onQualifiers("TRK", new String[0]).defaultValue("py").build(), Python.class, new Object[]{PythonProfile.class, PythonSensor.class, PythonRuleRepository.class, AnalysisWarningsWrapper.class});
        SonarRuntime sonarRuntime = context.getRuntime();
        if (sonarRuntime.getProduct() != SonarProduct.SONARLINT) {
            PythonPlugin.addCoberturaExtensions(context);
            PythonPlugin.addXUnitExtensions(context);
            PythonPlugin.addPylintExtensions(context);
            PythonPlugin.addBanditExtensions(context);
            PythonPlugin.addFlake8Extensions(context);
        }
        if (sonarRuntime.getProduct() == SonarProduct.SONARLINT) {
            SonarLintPluginAPIManager sonarLintPluginAPIManager = new SonarLintPluginAPIManager();
            sonarLintPluginAPIManager.addSonarlintPythonIndexer(context, new SonarLintPluginAPIVersion());
        }
    }

    private static void addCoberturaExtensions(Plugin.Context context) {
        context.addExtensions((Object)PropertyDefinition.builder((String)"sonar.python.coverage.reportPaths").index(20).name("Path to coverage report(s)").description("List of paths pointing to coverage reports. Ant patterns are accepted for relative path. The reports have to conform to the Cobertura XML format.").category(PYTHON_CATEGORY).subCategory(TEST_AND_COVERAGE).onQualifiers("TRK", new String[0]).defaultValue("coverage-reports/*coverage-*.xml").multiValues(true).build(), (Object)PropertyDefinition.builder((String)"sonar.python.coverage.reportPath").index(21).name("Path to coverage report").description("DEPRECATED : Use sonar.python.coverage.reportPaths instead. Path to a coverage report. Ant patterns are accepted for relative path. The report has to conform to the Cobertura XML format.").category(PYTHON_CATEGORY).subCategory(TEST_AND_COVERAGE).onQualifiers("TRK", new String[0]).defaultValue("").build(), new Object[]{PythonCoverageSensor.class});
    }

    private static void addXUnitExtensions(Plugin.Context context) {
        context.addExtensions((Object)PropertyDefinition.builder((String)"sonar.python.xunit.skipDetails").index(23).name("Skip the details when importing the Xunit reports").description("When enabled the test execution statistics is provided only on project level. Use this mode when paths in report are not found. Disabled by default.").category(PYTHON_CATEGORY).subCategory(TEST_AND_COVERAGE).onQualifiers("TRK", new String[0]).defaultValue("false").type(PropertyType.BOOLEAN).build(), (Object)PropertyDefinition.builder((String)"sonar.python.xunit.reportPath").index(24).name("Path to xunit report(s)").description("Path to the report of test execution, relative to project's root. Ant patterns are accepted. The reports have to conform to the junitreport XML format.").category(PYTHON_CATEGORY).subCategory(TEST_AND_COVERAGE).onQualifiers("TRK", new String[0]).defaultValue("xunit-reports/xunit-result-*.xml").build(), new Object[]{PythonXUnitSensor.class});
    }

    private static void addBanditExtensions(Plugin.Context context) {
        context.addExtensions(BanditSensor.class, (Object)PropertyDefinition.builder((String)"sonar.python.bandit.reportPaths").name("Bandit Report Files").description("Paths (absolute or relative) to json files with Bandit issues.").category(EXTERNAL_ANALYZERS_CATEGORY).subCategory(PYTHON_CATEGORY).onQualifiers("TRK", new String[0]).multiValues(true).build(), new Object[]{BanditRulesDefinition.class});
    }

    private static void addPylintExtensions(Plugin.Context context) {
        context.addExtensions(PylintSensor.class, (Object)PropertyDefinition.builder((String)"sonar.python.pylint.reportPaths").name("Pylint Report Files").description("Paths (absolute or relative) to report files with Pylint issues.").category(EXTERNAL_ANALYZERS_CATEGORY).subCategory(PYTHON_CATEGORY).onQualifiers("TRK", new String[0]).multiValues(true).build(), new Object[]{PylintRulesDefinition.class});
    }

    private static void addFlake8Extensions(Plugin.Context context) {
        context.addExtensions(Flake8Sensor.class, (Object)PropertyDefinition.builder((String)"sonar.python.flake8.reportPaths").name("Flake8 Report Files").description("Paths (absolute or relative) to report files with Flake8 issues.").category(EXTERNAL_ANALYZERS_CATEGORY).subCategory(PYTHON_CATEGORY).onQualifiers("TRK", new String[0]).multiValues(true).build(), new Object[]{Flake8RulesDefinition.class});
    }

    static class SonarLintPluginAPIVersion {
        SonarLintPluginAPIVersion() {
        }

        boolean isDependencyAvailable() {
            try {
                Class.forName("org.sonarsource.sonarlint.plugin.api.module.file.ModuleFileListener");
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            return true;
        }
    }

    static class SonarLintPluginAPIManager {
        SonarLintPluginAPIManager() {
        }

        public void addSonarlintPythonIndexer(Plugin.Context context, SonarLintPluginAPIVersion sonarLintPluginAPIVersion) {
            if (sonarLintPluginAPIVersion.isDependencyAvailable()) {
                context.addExtension(SonarLintPythonIndexer.class);
            } else {
                LOG.debug("Error while trying to inject SonarLintPythonIndexer");
            }
        }
    }
}

