/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import com.sonar.sslr.api.GenericTokenType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.PythonVisitorContext;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Trivia;
import org.sonar.python.SubscriptionVisitor;
import org.sonar.python.TokenLocation;
import org.sonar.python.api.PythonKeyword;
import org.sonar.python.api.PythonTokenType;

public class PythonHighlighter
extends PythonSubscriptionCheck {
    private NewHighlighting newHighlighting;
    private Set<Token> docStringTokens = new HashSet<Token>();

    public PythonHighlighter(SensorContext context, InputFile inputFile) {
        this.newHighlighting = context.newHighlighting();
        this.newHighlighting.onFile(inputFile);
    }

    @Override
    public void scanFile(PythonVisitorContext visitorContext) {
        SubscriptionVisitor.analyze(Collections.singletonList(this), visitorContext);
    }

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> this.checkFirstStatement(((FileInput)ctx.syntaxNode()).docstring()));
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> this.checkFirstStatement(((FunctionDef)ctx.syntaxNode()).docstring()));
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, ctx -> this.checkFirstStatement(((ClassDef)ctx.syntaxNode()).docstring()));
        context.registerSyntaxNodeConsumer(Tree.Kind.TOKEN, ctx -> this.visitToken((Token)ctx.syntaxNode()));
    }

    private void checkFirstStatement(@Nullable StringLiteral docString) {
        if (docString == null) {
            return;
        }
        for (Tree stringElement : docString.children()) {
            this.highlight(stringElement.firstToken(), TypeOfText.STRUCTURED_COMMENT);
            this.docStringTokens.add(stringElement.firstToken());
        }
    }

    private void visitToken(Token token) {
        if (token.type().equals(PythonTokenType.NUMBER)) {
            this.highlight(token, TypeOfText.CONSTANT);
        } else if (token.type() instanceof PythonKeyword) {
            this.highlight(token, TypeOfText.KEYWORD);
        } else if (token.type().equals(PythonTokenType.STRING) && !this.docStringTokens.contains(token)) {
            this.highlight(token, TypeOfText.STRING);
        } else if (token.type().equals(GenericTokenType.IDENTIFIER) && PythonHighlighter.isPython3Keyword(token.value())) {
            this.highlight(token, TypeOfText.KEYWORD);
        }
        for (Trivia trivia : token.trivia()) {
            this.highlight(trivia.token(), TypeOfText.COMMENT);
        }
    }

    private static boolean isPython3Keyword(String value) {
        return "await".equals(value) || "async".equals(value) || "match".equals(value) || "case".equals(value);
    }

    @Override
    public void leaveFile() {
        this.newHighlighting.save();
    }

    private void highlight(Token token, TypeOfText typeOfText) {
        TokenLocation tokenLocation = new TokenLocation(token);
        this.newHighlighting.highlight(tokenLocation.startLine(), tokenLocation.startLineOffset(), tokenLocation.endLine(), tokenLocation.endLineOffset(), typeOfText);
    }
}

