/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.xproc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sonar.java.Preconditions;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.Flow;
import org.sonar.java.se.FlowComputation;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintsByDomain;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.java.se.xproc.MethodBehavior;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonarsource.analyzer.commons.collections.PMap;

public abstract class MethodYield {
    final ExplodedGraph.Node node;
    private final Map<String, Map<String, Set<Flow>>> cachedFlows = new HashMap<String, Map<String, Set<Flow>>>();
    private final MethodBehavior behavior;
    List<ConstraintsByDomain> parametersConstraints = new ArrayList<ConstraintsByDomain>();

    protected MethodYield(MethodBehavior behavior) {
        this.node = null;
        this.behavior = behavior;
    }

    protected MethodYield(ExplodedGraph.Node node, MethodBehavior behavior) {
        this.node = node;
        this.behavior = behavior;
    }

    public abstract Stream<ProgramState> statesAfterInvocation(List<SymbolicValue> var1, List<Type> var2, ProgramState var3, Supplier<SymbolicValue> var4);

    public Stream<ProgramState> parametersAfterInvocation(List<SymbolicValue> invocationArguments, List<Type> invocationTypes, ProgramState programState) {
        Set<ProgramState> results = new LinkedHashSet<ProgramState>();
        for (int index = 0; index < invocationArguments.size(); ++index) {
            ConstraintsByDomain constraints = this.getConstraint(index, invocationTypes);
            if (constraints == null) continue;
            SymbolicValue invokedArg = invocationArguments.get(index);
            Set<ProgramState> programStates = MethodYield.programStatesForConstraint(results.isEmpty() ? Collections.singleton(programState) : results, invokedArg, constraints);
            if (programStates.isEmpty()) {
                return Stream.empty();
            }
            results = programStates;
        }
        if (results.isEmpty()) {
            results.add(programState);
        }
        return results.stream();
    }

    @CheckForNull
    private ConstraintsByDomain getConstraint(int index, List<Type> invocationTypes) {
        if (!this.behavior.isMethodVarArgs() || this.applicableOnVarArgs(index, invocationTypes)) {
            return this.parametersConstraints.get(index);
        }
        return null;
    }

    private boolean applicableOnVarArgs(int index, List<Type> types) {
        if (index < this.parametersConstraints.size() - 1) {
            return true;
        }
        if (this.parametersConstraints.size() != types.size()) {
            return false;
        }
        Type argumentType = types.get(index);
        return argumentType.isArray() || argumentType.is("<nulltype>");
    }

    private static Set<ProgramState> programStatesForConstraint(Collection<ProgramState> states, SymbolicValue invokedArg, ConstraintsByDomain constraints) {
        LinkedHashSet<ProgramState> programStates = new LinkedHashSet<ProgramState>(states);
        constraints.forEach((d, c) -> {
            LinkedHashSet<ProgramState> newPs = new LinkedHashSet<ProgramState>();
            for (ProgramState programState : programStates) {
                newPs.addAll(invokedArg.setConstraint(programState, (Constraint)c));
            }
            programStates.clear();
            programStates.addAll(newPs);
        });
        return programStates;
    }

    public boolean generatedByCheck(SECheck check) {
        return false;
    }

    public MethodBehavior methodBehavior() {
        return this.behavior;
    }

    public abstract String toString();

    public int hashCode() {
        return new HashCodeBuilder(7, 1291).append(this.parametersConstraints).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MethodYield other = (MethodYield)obj;
        return new EqualsBuilder().append(this.parametersConstraints, other.parametersConstraints).isEquals();
    }

    static Stream<Constraint> pmapToStream(@Nullable PMap<Class<? extends Constraint>, Constraint> pmap) {
        if (pmap == null) {
            return Stream.empty();
        }
        Stream.Builder result = Stream.builder();
        pmap.forEach((d, c) -> result.add(c));
        return result.build();
    }

    public Set<Flow> flow(List<Integer> parameterIndices, List<Class<? extends Constraint>> domains, int maxReturnedFlows) {
        Preconditions.checkArgument((!parameterIndices.isEmpty() ? 1 : 0) != 0, (String)"computing flow on empty symbolic value list should never happen");
        if (this.node == null || this.behavior == null) {
            return Collections.emptySet();
        }
        String key = parameterIndices.stream().sorted().map(Object::toString).collect(Collectors.joining(","));
        String domainKey = domains.stream().map(Class::getName).sorted().reduce("", String::concat);
        Map flowByDomain = this.cachedFlows.computeIfAbsent(key, k -> new HashMap());
        return flowByDomain.computeIfAbsent(domainKey, k -> {
            Set<SymbolicValue> symbolicValues = this.getSymbolicValues(parameterIndices);
            Set<Symbol> trackedSymbols = this.getReturnSymbolAsTrackedSymbols(parameterIndices);
            return FlowComputation.flow(this.node, symbolicValues, c -> true, c -> false, domains, trackedSymbols, maxReturnedFlows);
        });
    }

    private Set<Symbol> getReturnSymbolAsTrackedSymbols(List<Integer> parameterIndices) {
        Symbol symbol;
        if (parameterIndices.contains(-1) && this.node.programState.peekValue() == this.node.programState.exitValue() && (symbol = this.node.programState.peekValueSymbol().symbol()) != null) {
            return Collections.singleton(symbol);
        }
        return Collections.emptySet();
    }

    private Set<SymbolicValue> getSymbolicValues(List<Integer> parameterIndices) {
        HashSet parameterSVs = new HashSet();
        parameterIndices.stream().filter(i -> !this.behavior.isMethodVarArgs() || i < this.behavior.methodArity() - 1).forEach(parameterIndex -> {
            if (parameterIndex == -1) {
                parameterSVs.add(this.node.programState.exitValue());
            } else {
                parameterSVs.add(this.behavior.parameters().get((int)parameterIndex));
            }
        });
        return Collections.unmodifiableSet(parameterSVs);
    }
}

