/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.se.checks.AbstractXMLProcessing;
import org.sonar.java.se.checks.XxeProcessingCheck;
import org.sonar.java.se.checks.XxeProperty;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintsByDomain;
import org.sonar.plugins.java.api.semantic.MethodMatchers;

@Rule(key="S6374")
public class XmlParserLoadsExternalSchemasCheck
extends AbstractXMLProcessing {
    private static final List<Class<? extends Constraint>> DOMAINS = Arrays.asList(XxeProperty.FeatureLoadExternalDtd.class, XxeProcessingCheck.XmlSetValidating.class);

    @Override
    protected MethodMatchers getParsingMethods() {
        return XxeProcessingCheck.PARSING_METHODS;
    }

    @Override
    protected boolean isUnSecuredByProperty(@Nullable ConstraintsByDomain constraintsByDomain) {
        if (constraintsByDomain == null) {
            return false;
        }
        return (constraintsByDomain.hasConstraint(XxeProperty.FeatureLoadExternalDtd.UNSECURED) || constraintsByDomain.hasConstraint(XxeProcessingCheck.XmlSetValidating.ENABLE)) && !constraintsByDomain.hasConstraint(XxeProcessingCheck.XxeEntityResolver.CUSTOM_ENTITY_RESOLVER);
    }

    @Override
    protected String getMessage() {
        return "Disable loading of external schemas in XML parsing.";
    }

    @Override
    protected boolean shouldTrackConstraint(Constraint constraint) {
        return constraint == XxeProperty.FeatureLoadExternalDtd.UNSECURED || constraint == XxeProcessingCheck.XmlSetValidating.ENABLE;
    }

    @Override
    protected List<Class<? extends Constraint>> getDomains() {
        return DOMAINS;
    }
}

