/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.cfg.CFG;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.Flow;
import org.sonar.java.se.FlowComputation;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.ExceptionalYieldChecker;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.checks.SyntaxTreeNameFinder;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2259")
public class NullDereferenceCheck
extends SECheck {
    private static final ExceptionalYieldChecker EXCEPTIONAL_YIELD_CHECKER = new ExceptionalYieldChecker("\"NullPointerException\" will be thrown when invoking method \"%s()\".");
    private static final String JAVA_LANG_NPE = "java.lang.NullPointerException";
    private static final MethodMatchers OPTIONAL_OR_ELSE_GET_MATCHER = MethodMatchers.create().ofTypes(new String[]{"java.util.Optional"}).names(new String[]{"orElseGet"}).addParametersMatcher(new String[]{"java.util.function.Supplier"}).build();
    private Deque<Set<NullDereferenceIssue>> detectedIssues = new ArrayDeque<Set<NullDereferenceIssue>>();

    @Override
    public void init(MethodTree methodTree, CFG cfg) {
        this.detectedIssues.push(new HashSet());
    }

    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        SymbolicValue peekValue = context.getState().peekValue();
        if (peekValue == null) {
            return context.getState();
        }
        switch (syntaxNode.kind()) {
            case METHOD_INVOCATION: {
                MethodInvocationTree methodInvocation = (MethodInvocationTree)syntaxNode;
                ExpressionTree methodSelect = methodInvocation.methodSelect();
                ProgramState ps = context.getState();
                if (OPTIONAL_OR_ELSE_GET_MATCHER.matches(methodInvocation) && (ps = this.checkConstraint(context, (Tree)methodInvocation.arguments().get(0), peekValue)) == null) {
                    return ps;
                }
                if (!methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) break;
                SymbolicValue dereferencedSV = context.getState().peekValue(methodInvocation.arguments().size());
                return this.checkConstraint(ps, context, (Tree)methodSelect, dereferencedSV);
            }
            case ARRAY_ACCESS_EXPRESSION: {
                ExpressionTree arrayAccessNode = ((ArrayAccessExpressionTree)syntaxNode).expression();
                SymbolicValue arrayAccessSV = context.getState().peekValue(1);
                return this.checkConstraint(context, (Tree)arrayAccessNode, arrayAccessSV);
            }
            case MEMBER_SELECT: {
                return this.checkMemberSelect(context, (MemberSelectExpressionTree)syntaxNode, peekValue);
            }
            case SYNCHRONIZED_STATEMENT: {
                return this.checkConstraint(context, syntaxNode, peekValue);
            }
        }
        return context.getState();
    }

    private ProgramState checkMemberSelect(CheckerContext context, MemberSelectExpressionTree mse, SymbolicValue currentVal) {
        if ("class".equals(mse.identifier().name())) {
            return context.getState();
        }
        return this.checkConstraint(context, (Tree)mse, currentVal);
    }

    private ProgramState checkConstraint(CheckerContext context, Tree syntaxNode, SymbolicValue currentVal) {
        return this.checkConstraint(context.getState(), context, syntaxNode, currentVal);
    }

    private ProgramState checkConstraint(ProgramState programState, CheckerContext context, Tree syntaxNode, SymbolicValue currentVal) {
        ObjectConstraint constraint = programState.getConstraint(currentVal, ObjectConstraint.class);
        if (constraint != null && constraint.isNull()) {
            NullDereferenceIssue issue = new NullDereferenceIssue(context.getNode(), currentVal, syntaxNode);
            this.detectedIssues.peek().add(issue);
            context.addExceptionalYield(currentVal, programState, JAVA_LANG_NPE, this);
            return null;
        }
        constraint = programState.getConstraint(currentVal, ObjectConstraint.class);
        if (constraint == null) {
            context.addExceptionalYield(currentVal, programState.addConstraint(currentVal, ObjectConstraint.NULL), JAVA_LANG_NPE, this);
            return programState.addConstraint(currentVal, ObjectConstraint.NOT_NULL);
        }
        return programState;
    }

    private void reportIssue(SymbolicValue currentVal, Tree syntaxNode, ExplodedGraph.Node node) {
        Object message = "A \"NullPointerException\" could be thrown; ";
        message = syntaxNode.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && ((MemberSelectExpressionTree)syntaxNode).expression().is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) ? (String)message + "\"" + SyntaxTreeNameFinder.getName(syntaxNode) + "()\" can return null." : (String)message + "\"" + SyntaxTreeNameFinder.getName(syntaxNode) + "\" is nullable here.";
        SymbolicValue val = null;
        if (!SymbolicValue.NULL_LITERAL.equals(currentVal)) {
            val = currentVal;
        }
        Symbol dereferencedSymbol = NullDereferenceCheck.dereferencedSymbol(syntaxNode);
        Set<Flow> flows = FlowComputation.flow(node, val, Collections.singletonList(ObjectConstraint.class), dereferencedSymbol, 20).stream().filter(f -> !f.isEmpty()).map(f -> NullDereferenceCheck.addDereferenceMessage(f, syntaxNode)).collect(Collectors.toSet());
        this.reportIssue(syntaxNode, (String)message, flows);
    }

    @Nullable
    private static Symbol dereferencedSymbol(Tree syntaxNode) {
        if (syntaxNode.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            ExpressionTree memberSelectExpr = ((MemberSelectExpressionTree)syntaxNode).expression();
            if (memberSelectExpr.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                return ((IdentifierTree)memberSelectExpr).symbol();
            }
        }
        return null;
    }

    private static Flow addDereferenceMessage(Flow flow, Tree syntaxNode) {
        String symbolName = SyntaxTreeNameFinder.getName(syntaxNode);
        String msg = syntaxNode.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && ((MemberSelectExpressionTree)syntaxNode).expression().is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) ? String.format("Result of '%s()' is dereferenced.", symbolName) : String.format("'%s' is dereferenced.", symbolName);
        return Flow.builder().add(new JavaFileScannerContext.Location(msg, syntaxNode)).addAll(flow).build();
    }

    @Override
    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        SymbolicValue peek;
        NullDereferenceIssue issue = null;
        if (syntaxNode.is(new Tree.Kind[]{Tree.Kind.SWITCH_STATEMENT})) {
            int numberOfCaseValues = ((SwitchStatementTree)syntaxNode).cases().stream().flatMap(c -> c.labels().stream()).map(CaseLabelTree::expressions).mapToInt(List::size).sum();
            SymbolicValue conditionSymbolicValue = context.getState().peekValue(numberOfCaseValues);
            if (context.getConstraintManager().isNull(context.getState(), conditionSymbolicValue)) {
                issue = new NullDereferenceIssue(context.getNode(), conditionSymbolicValue, syntaxNode);
            }
        }
        if (syntaxNode.is(new Tree.Kind[]{Tree.Kind.THROW_STATEMENT}) && (peek = context.getState().peekValue()) != null && context.getConstraintManager().isNull(context.getState(), peek)) {
            issue = new NullDereferenceIssue(context.getNode(), peek, syntaxNode);
        }
        if (issue != null) {
            this.detectedIssues.peek().add(issue);
            context.createSink();
            return context.getState();
        }
        List<ProgramState> programStates = NullDereferenceCheck.setNullConstraint(context, syntaxNode);
        for (ProgramState programState : programStates) {
            context.addTransition(programState);
        }
        return context.getState();
    }

    private static List<ProgramState> setNullConstraint(CheckerContext context, Tree syntaxNode) {
        SymbolicValue val = context.getState().peekValue();
        if (syntaxNode.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && ((MethodInvocationTree)syntaxNode).symbol().metadata().nullabilityData().isStrongNullable(SymbolMetadata.NullabilityLevel.PACKAGE, false, false)) {
            Objects.requireNonNull(val);
            ArrayList<ProgramState> states = new ArrayList<ProgramState>();
            states.addAll(val.setConstraint(context.getState(), ObjectConstraint.NULL));
            states.addAll(val.setConstraint(context.getState(), ObjectConstraint.NOT_NULL));
            return states;
        }
        return Collections.singletonList(context.getState());
    }

    @Override
    public void checkEndOfExecutionPath(CheckerContext context, ConstraintManager constraintManager) {
        EXCEPTIONAL_YIELD_CHECKER.reportOnExceptionalYield(context.getNode(), this);
    }

    @Override
    public void checkEndOfExecution(CheckerContext context) {
        this.reportIssues();
    }

    @Override
    public void interruptedExecution(CheckerContext context) {
        this.reportIssues();
    }

    private void reportIssues() {
        Set<NullDereferenceIssue> issues = this.detectedIssues.pop();
        issues.forEach(issue -> this.reportIssue(issue.symbolicValue, issue.tree, issue.node));
    }

    private static class NullDereferenceIssue {
        final ExplodedGraph.Node node;
        final SymbolicValue symbolicValue;
        final Tree tree;

        private NullDereferenceIssue(ExplodedGraph.Node node, SymbolicValue symbolicValue, Tree tree) {
            this.node = node;
            this.symbolicValue = symbolicValue;
            this.tree = tree;
        }
    }
}

