/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.se.checks.AbstractXMLProcessing;
import org.sonar.java.se.checks.XxeProcessingCheck;
import org.sonar.java.se.checks.XxeProperty;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintsByDomain;
import org.sonar.plugins.java.api.semantic.MethodMatchers;

@Rule(key="S6373")
public class AllowXMLInclusionCheck
extends AbstractXMLProcessing {
    private static final List<Class<? extends Constraint>> DOMAINS = Arrays.asList(XxeProperty.FeatureXInclude.class, XxeProcessingCheck.XmlSetXIncludeAware.class);

    @Override
    protected MethodMatchers getParsingMethods() {
        return XxeProcessingCheck.PARSING_METHODS;
    }

    @Override
    protected boolean isUnSecuredByProperty(@Nullable ConstraintsByDomain constraintsByDomain) {
        if (constraintsByDomain == null) {
            return false;
        }
        return (constraintsByDomain.hasConstraint(XxeProperty.FeatureXInclude.ENABLE) || constraintsByDomain.hasConstraint(XxeProcessingCheck.XmlSetXIncludeAware.ENABLE)) && !constraintsByDomain.hasConstraint(XxeProcessingCheck.XxeEntityResolver.CUSTOM_ENTITY_RESOLVER);
    }

    @Override
    protected String getMessage() {
        return "Disable the inclusion of files in XML processing.";
    }

    @Override
    protected boolean shouldTrackConstraint(Constraint constraint) {
        return constraint == XxeProperty.FeatureXInclude.ENABLE || constraint == XxeProcessingCheck.XmlSetXIncludeAware.ENABLE;
    }

    @Override
    protected List<Class<? extends Constraint>> getDomains() {
        return DOMAINS;
    }
}

