/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.sonar.java.model.JSema;
import org.sonar.java.model.JSymbol;
import org.sonar.java.model.Symbols;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.VariableTree;

final class JTypeSymbol
extends JSymbol
implements Symbol.TypeSymbol {
    private Type superclass = Symbols.unknownType;
    private List<Type> interfaces;
    private Collection<Symbol> memberSymbols;
    final SpecialField superSymbol = new SpecialField(){

        @Override
        public String name() {
            return "super";
        }

        @Override
        public Type type() {
            if (JTypeSymbol.this.typeBinding().isInterface()) {
                return JTypeSymbol.this.type();
            }
            return JTypeSymbol.this.superClass();
        }
    };
    final SpecialField thisSymbol = new SpecialField(){

        @Override
        public String name() {
            return "this";
        }

        @Override
        public Type type() {
            return JTypeSymbol.this.type();
        }
    };

    JTypeSymbol(JSema sema, ITypeBinding typeBinding) {
        super(sema, (IBinding)typeBinding);
    }

    ITypeBinding typeBinding() {
        return (ITypeBinding)this.binding;
    }

    @Override
    @CheckForNull
    public Type superClass() {
        if (this.superclass == Symbols.unknownType) {
            this.superclass = this.convertSuperClass();
        }
        return this.superclass;
    }

    @CheckForNull
    private Type convertSuperClass() {
        if (this.typeBinding().isInterface() || this.typeBinding().isArray()) {
            return this.sema.type(Objects.requireNonNull(this.sema.resolveType("java.lang.Object")));
        }
        if (this.typeBinding().getSuperclass() == null) {
            return null;
        }
        return this.sema.type(this.typeBinding().getSuperclass());
    }

    @Override
    public List<Type> interfaces() {
        if (this.interfaces == null) {
            this.interfaces = this.sema.types(this.typeBinding().getInterfaces());
        }
        return this.interfaces;
    }

    @Override
    public Collection<Symbol> memberSymbols() {
        if (this.memberSymbols == null) {
            this.memberSymbols = this.convertMemberSymbols();
        }
        return this.memberSymbols;
    }

    private Collection<Symbol> convertMemberSymbols() {
        ArrayList<Symbol> members = new ArrayList<Symbol>();
        for (ITypeBinding iTypeBinding : this.typeBinding().getDeclaredTypes()) {
            members.add(this.sema.typeSymbol(iTypeBinding));
        }
        for (ITypeBinding iTypeBinding : this.typeBinding().getDeclaredFields()) {
            members.add(this.sema.variableSymbol((IVariableBinding)iTypeBinding));
        }
        for (ITypeBinding iTypeBinding : this.typeBinding().getDeclaredMethods()) {
            members.add(this.sema.methodSymbol((IMethodBinding)iTypeBinding));
        }
        return members;
    }

    @Override
    public Collection<Symbol> lookupSymbols(String name) {
        return this.memberSymbols().stream().filter(m -> name.equals(m.name())).collect(Collectors.toSet());
    }

    @Override
    @Nullable
    public ClassTree declaration() {
        return (ClassTree)super.declaration();
    }

    abstract class SpecialField
    extends Symbols.DefaultSymbol
    implements Symbol.VariableSymbol {
        SpecialField() {
        }

        @Override
        public final Symbol owner() {
            return JTypeSymbol.this;
        }

        @Override
        public final boolean isVariableSymbol() {
            return true;
        }

        @Override
        public final boolean isFinal() {
            return true;
        }

        @Override
        public final boolean isUnknown() {
            return false;
        }

        @Override
        public final Symbol.TypeSymbol enclosingClass() {
            return JTypeSymbol.this;
        }

        @Override
        public final List<IdentifierTree> usages() {
            return Collections.emptyList();
        }

        @Override
        @Nullable
        public final VariableTree declaration() {
            return null;
        }
    }
}

