/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jdt.core.compiler.IProblem;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.collections.SetUtils;

public class JProblem {
    private static final String USE_ENABLE_PREVIEW = " Use --enable-preview to enable";
    private final String message;
    private final Type type;

    JProblem(String message, Type type) {
        this.message = message;
        this.type = type;
    }

    public Type type() {
        return this.type;
    }

    public String message() {
        return this.message;
    }

    public String toString() {
        if (this.type == Type.PREVIEW_FEATURE_USED) {
            return JProblem.cleanMessage(this.message);
        }
        return this.message;
    }

    private static String cleanMessage(String message) {
        if (message.endsWith(USE_ENABLE_PREVIEW)) {
            return message.substring(0, message.length() - USE_ENABLE_PREVIEW.length());
        }
        return message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JProblem)) {
            return false;
        }
        JProblem that = (JProblem)o;
        return this.type == that.type && this.message.equals(that.message);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.message});
    }

    public static enum Type {
        UNDEFINED_TYPE(0x1000002),
        PREVIEW_FEATURE_USED(0x400450),
        UNUSED_IMPORT(268435844, "org.eclipse.jdt.core.compiler.problem.unusedImport", Tree.Kind.IMPORT),
        REDUNDANT_CAST(553648309, "org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", Tree.Kind.TYPE_CAST, Tree.Kind.PARENTHESIZED_EXPRESSION),
        ASSIGNMENT_HAS_NO_EFFECT(0x200000B2, "org.eclipse.jdt.core.compiler.problem.noEffectAssignment", Tree.Kind.ASSIGNMENT),
        MASKED_CATCH(16777381, "org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", Tree.Kind.IDENTIFIER, Tree.Kind.MEMBER_SELECT);

        private final int warningID;
        private final String compilerOptionKey;
        private final Set<Tree.Kind> kinds;
        private static final Set<String> COMPILER_OPTIONS;

        private Type(int warningID) {
            this.warningID = warningID;
            this.compilerOptionKey = null;
            this.kinds = Collections.emptySet();
        }

        private Type(int warningID, String compilerOptionKey, Tree.Kind ... kinds) {
            this.warningID = warningID;
            this.compilerOptionKey = compilerOptionKey;
            this.kinds = SetUtils.immutableSetOf((Object[])kinds);
        }

        boolean matches(IProblem warning) {
            return warning.getID() == this.warningID;
        }

        public static Set<String> compilerOptions() {
            if (COMPILER_OPTIONS.isEmpty()) {
                Stream.of(Type.values()).map(t -> t.compilerOptionKey).forEach(COMPILER_OPTIONS::add);
            }
            return Collections.unmodifiableSet(COMPILER_OPTIONS);
        }

        public Set<Tree.Kind> getKinds() {
            return this.kinds;
        }

        static {
            COMPILER_OPTIONS = new HashSet<String>();
        }
    }
}

