/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.externalreport;

import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.externalreport.CheckstyleXmlReportReader;
import org.sonar.java.externalreport.ExternalIssueUtils;
import org.sonarsource.analyzer.commons.ExternalReportProvider;
import org.sonarsource.analyzer.commons.ExternalRuleLoader;

public class CheckstyleSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(CheckstyleSensor.class);
    private static final String LINTER_NAME = "Checkstyle";
    private static final String LANGUAGE_KEY = "java";
    public static final String REPORT_PROPERTY_KEY = "sonar.java.checkstyle.reportPaths";
    public static final String LINTER_KEY = "checkstyle";
    public static final ExternalRuleLoader RULE_LOADER = new ExternalRuleLoader("checkstyle", "Checkstyle", "org/sonar/l10n/java/rules/checkstyle/rules.json", "java");

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage(LANGUAGE_KEY).onlyWhenConfiguration(conf -> conf.hasKey(REPORT_PROPERTY_KEY)).name("Import of Checkstyle issues");
    }

    public void execute(SensorContext context) {
        List reportFiles = ExternalReportProvider.getReportFiles((SensorContext)context, (String)REPORT_PROPERTY_KEY);
        reportFiles.forEach(report -> ExternalIssueUtils.importIfExist(LINTER_NAME, context, report, CheckstyleSensor::importReport));
    }

    private static void importReport(File reportPath, SensorContext context) {
        try (FileInputStream in = new FileInputStream(reportPath);){
            LOG.info("Importing {}", (Object)reportPath);
            CheckstyleXmlReportReader.read(context, in, CheckstyleSensor::saveIssue);
        }
        catch (Exception e) {
            LOG.error("Failed to import external issues report: " + String.valueOf(reportPath), (Throwable)e);
        }
    }

    private static void saveIssue(SensorContext context, InputFile inputFile, String key, String line, String message) {
        ExternalIssueUtils.saveIssue(context, RULE_LOADER, inputFile, LINTER_KEY, key, line, message);
    }
}

