/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.php;

import java.util.EnumSet;
import java.util.Set;
import org.sonarsource.analyzer.commons.regex.CharacterParser;
import org.sonarsource.analyzer.commons.regex.RegexFeature;
import org.sonarsource.analyzer.commons.regex.RegexSource;
import org.sonarsource.analyzer.commons.regex.php.PhpStringCharacterParser;

public class PhpRegexSource
extends RegexSource {
    private static final Set<RegexFeature> FEATURES = EnumSet.of(RegexFeature.RECURSION, new RegexFeature[]{RegexFeature.CONDITIONAL_SUBPATTERN, RegexFeature.POSIX_CHARACTER_CLASS, RegexFeature.JAVA_SYNTAX_GROUP_NAME, RegexFeature.DOTNET_SYNTAX_GROUP_NAME, RegexFeature.PERL_SYNTAX_GROUP_NAME, RegexFeature.PYTHON_SYNTAX_GROUP_NAME, RegexFeature.ATOMIC_GROUP, RegexFeature.POSSESSIVE_QUANTIFIER, RegexFeature.ESCAPED_CHARACTER_CLASS, RegexFeature.UNESCAPED_CURLY_BRACKET});
    private final char quote;

    public PhpRegexSource(String source, char quote) {
        super(source);
        this.quote = quote;
    }

    @Override
    public CharacterParser createCharacterParser() {
        if (this.quote == '\'') {
            return PhpStringCharacterParser.forSingleQuotedString(this);
        }
        return PhpStringCharacterParser.forDoubleQuotedString(this);
    }

    @Override
    public Set<RegexFeature> features() {
        return FEATURES;
    }
}

