/*
 * Decompiled with CFR 0.152.
 */
package com.sonarsource.checks.verifier.internal;

import com.sonarsource.checks.verifier.internal.PreciseLocation;
import com.sonarsource.checks.verifier.internal.UnderlinedRange;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;

public class PerLineLocationWriter {
    private final int indent;
    private final List<PreciseLocation> locations = new ArrayList<PreciseLocation>();
    private final List<StringBuilder> outputLines = new ArrayList<StringBuilder>();

    public PerLineLocationWriter(String lineNumber, String sourceCodeLine) {
        this.indent = lineNumber.length();
        this.outputLines.add(new StringBuilder().append(lineNumber).append(sourceCodeLine));
    }

    public void add(PreciseLocation location) {
        this.locations.add(location);
    }

    public void write(StringBuilder out, @Nullable UnderlinedRange primaryRange) {
        this.locations.sort(Comparator.comparing(location -> location.range));
        for (PreciseLocation location2 : this.locations) {
            boolean primaryIsWritten = primaryRange != null && primaryRange.compareTo(location2.range) <= 0;
            location2.write(this.indent, this.availableStringBuilder(location2), primaryIsWritten);
        }
        for (StringBuilder locationLine : this.outputLines) {
            out.append((CharSequence)locationLine).append('\n');
        }
    }

    private StringBuilder availableStringBuilder(PreciseLocation location) {
        int availableLineIndex;
        int column = this.indent + location.range.column;
        for (availableLineIndex = 1; availableLineIndex < this.outputLines.size() && !PerLineLocationWriter.isAvailable(column, this.outputLines.get(availableLineIndex)); ++availableLineIndex) {
        }
        if (availableLineIndex >= this.outputLines.size()) {
            StringBuilder newLine = new StringBuilder();
            this.outputLines.add(newLine);
            return newLine;
        }
        return this.outputLines.get(availableLineIndex);
    }

    private static boolean isAvailable(int column, StringBuilder line) {
        int index = column - 1;
        return line.length() < index || line.length() == index && line.charAt(index - 1) != '^';
    }
}

