/*
 * Decompiled with CFR 0.152.
 */
package com.sonarsource.checks.verifier.internal;

import com.sonarsource.checks.verifier.internal.LineIssues;
import com.sonarsource.checks.verifier.internal.PreciseLocationParser;
import com.sonarsource.checks.verifier.internal.TestFile;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class NoncompliantCommentParser {
    private static final Pattern START_WITH_NONCOMPLIANT = Pattern.compile("^(?i) *+Noncompliant");
    private static final Pattern NON_COMPLIANT_REGEX = Pattern.compile("(?i) *+Noncompliant(?:@(?<lineAdjustment>(?<relativeAdjustment>[+-])?\\d++))?(?: ++(?<issueCount>\\d++))? *+(?<messages>(\\{\\{.*?\\}\\} *+)+)?(?:\\[\\[(?<params>[^\\]]++)\\]\\] *+)?(?:\r(\n?)|\n)?");

    private NoncompliantCommentParser() {
    }

    @Nullable
    public static LineIssues parse(TestFile testFile, int line, String commentContent) {
        if (START_WITH_NONCOMPLIANT.matcher(commentContent).find()) {
            Matcher matcher = NON_COMPLIANT_REGEX.matcher(commentContent);
            if (!matcher.matches()) {
                throw new IllegalStateException("Invalid comment format line " + line + ": " + commentContent);
            }
            int effectiveLine = PreciseLocationParser.extractEffectiveLine(line, matcher);
            String[] messages = NoncompliantCommentParser.extractMessages(line, matcher.group("issueCount"), matcher.group("messages"));
            Map<String, String> params = NoncompliantCommentParser.extractParams(matcher.group("params"));
            return new LineIssues(testFile, effectiveLine, messages, params, null);
        }
        return null;
    }

    static Map<String, String> extractParams(@Nullable String paramGroup) {
        if (paramGroup == null) {
            return Collections.emptyMap();
        }
        return Arrays.stream(paramGroup.trim().split(";")).map(s -> s.split("=", 2)).collect(Collectors.toMap(arr -> arr[0], arr -> ((String[])arr).length == 2 ? arr[1] : ""));
    }

    private static String[] extractMessages(int line, @Nullable String issueCountGroup, @Nullable String messageGroup) {
        if (messageGroup != null) {
            if (issueCountGroup != null) {
                throw new IllegalStateException("Error, you can not specify issue count and messages at line " + line + ", you have to choose either: \n  Noncompliant " + issueCountGroup + "\nor\n  Noncompliant " + messageGroup + "\n");
            }
            String messageContent = messageGroup.trim();
            return messageContent.substring(2, messageContent.length() - 2).split("\\}\\} *+\\{\\{");
        }
        int issueCount = issueCountGroup == null ? 1 : Integer.parseInt(issueCountGroup);
        return new String[issueCount];
    }
}

