/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.flatfile.function;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.smooks.assertion.AssertArgument;
import org.smooks.cartridges.flatfile.function.StringFunction;
import org.smooks.cartridges.flatfile.function.StringFunctionDefinitionParser;

public class StringFunctionExecutor {
    private static final ConcurrentMap<String, StringFunctionExecutor> cache = new ConcurrentHashMap<String, StringFunctionExecutor>();
    private final List<StringFunction> functions;
    private final String functionDefinition;

    public static StringFunctionExecutor getInstance(String functionDefinition) {
        StringFunctionExecutor existing;
        StringFunctionExecutor executor = (StringFunctionExecutor)cache.get(functionDefinition);
        if (executor == null && (existing = cache.putIfAbsent(functionDefinition, executor = new StringFunctionExecutor(functionDefinition, StringFunctionDefinitionParser.parse(functionDefinition)))) != null) {
            executor = existing;
        }
        return executor;
    }

    private StringFunctionExecutor(String functionDefinition, List<StringFunction> functions) {
        this.functionDefinition = functionDefinition;
        this.functions = functions;
    }

    public String execute(String input) {
        AssertArgument.isNotNull((Object)input, (String)"input");
        for (StringFunction function : this.functions) {
            input = function.execute(input);
        }
        return input;
    }

    public String toString() {
        return String.format("%s[functionDefinition=%s]", this, this.functionDefinition);
    }
}

