/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.flatfile.function;

import java.util.ArrayList;
import java.util.List;
import org.smooks.cartridges.flatfile.function.CapitalizeFirstFunction;
import org.smooks.cartridges.flatfile.function.CapitalizeFunction;
import org.smooks.cartridges.flatfile.function.LeftTrimFunction;
import org.smooks.cartridges.flatfile.function.LowerCaseFunction;
import org.smooks.cartridges.flatfile.function.RightTrimFunction;
import org.smooks.cartridges.flatfile.function.StringFunction;
import org.smooks.cartridges.flatfile.function.TrimFunction;
import org.smooks.cartridges.flatfile.function.UncapitalizeFirstFunction;
import org.smooks.cartridges.flatfile.function.UnknownStringFunctionException;
import org.smooks.cartridges.flatfile.function.UpperCaseFunction;

public final class StringFunctionDefinitionParser {
    public static final TrimFunction TRIM_FUNCTION = new TrimFunction();
    public static final LeftTrimFunction LEFT_TRIM_FUNCTION = new LeftTrimFunction();
    public static final RightTrimFunction RIGHT_TRIM_FUNCTION = new RightTrimFunction();
    public static final UpperCaseFunction UPPER_CASE_FUNCTION = new UpperCaseFunction();
    public static final LowerCaseFunction LOWER_CASE_FUNCTION = new LowerCaseFunction();
    public static final CapitalizeFunction CAPITALIZE_FUNCTION = new CapitalizeFunction();
    public static final CapitalizeFirstFunction CAPITALIZE_FIRST_FUNCTION = new CapitalizeFirstFunction();
    public static final UncapitalizeFirstFunction UNCAPITALIZE_FIRST_FUNCTION = new UncapitalizeFirstFunction();
    public static final String TRIM_DEFINITION = "trim";
    public static final String LEFT_TRIM_DEFINITION = "left_trim";
    public static final String RIGHT_TRIM_DEFINITION = "right_trim";
    public static final String UPPER_CASE_DEFINITION = "upper_case";
    public static final String LOWER_CASE_DEFINITION = "lower_case";
    public static final String CAPITALIZE_DEFINITION = "capitalize";
    public static final String CAPITALIZE_FIRST_DEFINITION = "cap_first";
    public static final String UNCAPITALIZE_FIRST_DEFINITION = "uncap_first";
    public static final String SEPARATOR = ".";

    private StringFunctionDefinitionParser() {
    }

    public static List<StringFunction> parse(String definition) {
        ArrayList<StringFunction> functions = new ArrayList<StringFunction>();
        String[] functionsDef = definition.startsWith(SEPARATOR) && definition.length() > 1 ? definition.substring(1).split("\\.") : definition.split("\\.");
        String[] stringArray = functionsDef;
        int n = stringArray.length;
        block20: for (int i = 0; i < n; ++i) {
            String functionDef;
            switch (functionDef = stringArray[i]) {
                case "trim": {
                    functions.add(TRIM_FUNCTION);
                    continue block20;
                }
                case "left_trim": {
                    functions.add(LEFT_TRIM_FUNCTION);
                    continue block20;
                }
                case "right_trim": {
                    functions.add(RIGHT_TRIM_FUNCTION);
                    continue block20;
                }
                case "upper_case": {
                    functions.add(UPPER_CASE_FUNCTION);
                    continue block20;
                }
                case "lower_case": {
                    functions.add(LOWER_CASE_FUNCTION);
                    continue block20;
                }
                case "capitalize": {
                    functions.add(CAPITALIZE_FUNCTION);
                    continue block20;
                }
                case "cap_first": {
                    functions.add(CAPITALIZE_FIRST_FUNCTION);
                    continue block20;
                }
                case "uncap_first": {
                    functions.add(UNCAPITALIZE_FIRST_FUNCTION);
                    continue block20;
                }
                default: {
                    throw new UnknownStringFunctionException("The function '" + functionDef + "' in the function definition '" + definition + "' is unknown.");
                }
            }
        }
        return functions;
    }
}

