/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.text.serialization;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.sklsft.commons.text.StringUtils;
import org.sklsft.commons.text.serialization.Serializer;
import org.sklsft.commons.text.serialization.exceptions.SerializationException;

public class XmlSerializer
implements Serializer {
    private Map<Class<?>, JAXBContext> contexts = new HashMap();

    @Override
    public String serialize(Object object) {
        if (object == null) {
            return null;
        }
        try {
            Class<?> clazz = object.getClass();
            JAXBContext context = this.getContext(clazz);
            StringWriter stringWriter = new StringWriter();
            Marshaller marshaller = context.createMarshaller();
            if (clazz.isAnnotationPresent(XmlRootElement.class)) {
                marshaller.marshal(object, (Writer)stringWriter);
                return stringWriter.toString();
            }
            QName qName = new QName(clazz.getPackage().getName(), clazz.getName());
            marshaller.marshal((Object)new JAXBElement(qName, clazz, object), (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (Exception e) {
            throw new SerializationException("failed to serialize object : " + e.getMessage(), e);
        }
    }

    public <T> String serialize(JAXBElement<T> element) {
        if (element == null) {
            return null;
        }
        try {
            Class clazz = element.getDeclaredType();
            JAXBContext context = this.getContext(clazz);
            StringWriter stringWriter = new StringWriter();
            Marshaller marshaller = context.createMarshaller();
            marshaller.marshal(element, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (Exception e) {
            throw new SerializationException("failed to serialize object : " + e.getMessage(), e);
        }
    }

    @Override
    public <T> T deserialize(String arg, Class<T> targetClass) {
        if (StringUtils.isEmpty(arg)) {
            return null;
        }
        try {
            JAXBContext context = this.getContext(targetClass);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            if (targetClass.isAnnotationPresent(XmlRootElement.class)) {
                return (T)unmarshaller.unmarshal((Reader)new StringReader(arg));
            }
            return (T)unmarshaller.unmarshal((Source)new StreamSource(new StringReader(arg)), targetClass).getValue();
        }
        catch (Exception e) {
            throw new SerializationException("failed to deserialize object : " + e.getMessage(), e);
        }
    }

    private JAXBContext getContext(Class<?> clazz) throws JAXBException {
        JAXBContext context = this.contexts.get(clazz);
        if (context == null) {
            context = JAXBContext.newInstance((Class[])new Class[]{clazz});
            this.contexts.put(clazz, context);
        }
        return context;
    }
}

