/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.text.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.sklsft.commons.text.serialization.Serializer;
import org.sklsft.commons.text.serialization.exceptions.SerializationException;

public class JsonSerializer
implements Serializer {
    private ObjectMapper objectMapper;

    public JsonSerializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public String serialize(Object object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new SerializationException("failed to serialize object : " + e.getMessage(), e);
        }
    }

    @Override
    public <T> T deserialize(String arg, Class<T> targetClass) {
        try {
            return (T)this.objectMapper.readValue(arg, targetClass);
        }
        catch (JsonProcessingException e) {
            throw new SerializationException("failed to deserialize object : " + e.getMessage(), e);
        }
    }
}

