/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal;

import java.util.Optional;
import javax.net.ssl.SSLSocketFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.mailer.Mailer;
import org.simplejavamail.api.mailer.MailerRegularBuilder;
import org.simplejavamail.api.mailer.config.ServerConfig;
import org.simplejavamail.api.mailer.config.TransportStrategy;
import org.simplejavamail.config.ConfigLoader;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;
import org.simplejavamail.mailer.internal.MailerGenericBuilderImpl;
import org.simplejavamail.mailer.internal.MailerImpl;
import org.simplejavamail.mailer.internal.ServerConfigImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailerRegularBuilderImpl
extends MailerGenericBuilderImpl<MailerRegularBuilderImpl>
implements MailerRegularBuilder<MailerRegularBuilderImpl> {
    private static final Logger log = LoggerFactory.getLogger(MailerRegularBuilderImpl.class);
    private String host;
    private Integer port;
    private String username;
    private String password;
    @NotNull
    private TransportStrategy transportStrategy;
    private String customSSLFactory;
    private SSLSocketFactory customSSLFactoryInstance;

    @Deprecated
    public MailerRegularBuilderImpl() {
        if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.SMTP_HOST)) {
            this.withSMTPServerHost((String)Preconditions.verifyNonnullOrEmpty((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.SMTP_HOST)));
        }
        if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.SMTP_PORT)) {
            this.withSMTPServerPort((Integer)Preconditions.verifyNonnullOrEmpty((Object)ConfigLoader.getIntegerProperty((ConfigLoader.Property)ConfigLoader.Property.SMTP_PORT)));
        }
        if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.SMTP_USERNAME)) {
            this.withSMTPServerUsername((String)Preconditions.verifyNonnullOrEmpty((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.SMTP_USERNAME)));
        }
        if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.SMTP_PASSWORD)) {
            this.withSMTPServerPassword((String)Preconditions.verifyNonnullOrEmpty((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.SMTP_PASSWORD)));
        }
        this.transportStrategy = TransportStrategy.SMTP;
        if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.TRANSPORT_STRATEGY)) {
            this.withTransportStrategy((TransportStrategy)Preconditions.verifyNonnullOrEmpty((Object)ConfigLoader.getProperty((ConfigLoader.Property)ConfigLoader.Property.TRANSPORT_STRATEGY)));
        }
        if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.CUSTOM_SSLFACTORY_CLASS)) {
            this.withCustomSSLFactoryClass((String)Preconditions.verifyNonnullOrEmpty((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.CUSTOM_SSLFACTORY_CLASS)));
        }
    }

    public MailerRegularBuilderImpl withTransportStrategy(@NotNull TransportStrategy transportStrategy) {
        this.transportStrategy = transportStrategy;
        return this;
    }

    public MailerRegularBuilderImpl withSMTPServer(@Nullable String host, @Nullable Integer port, @Nullable String username, @Nullable String password) {
        return this.withSMTPServerHost(host).withSMTPServerPort(port).withSMTPServerUsername((String)MiscUtil.emptyAsNull((Object)username)).withSMTPServerPassword((String)MiscUtil.emptyAsNull((Object)password));
    }

    public MailerRegularBuilderImpl withSMTPServer(@Nullable String host, @Nullable Integer port, @Nullable String username) {
        return this.withSMTPServerHost(host).withSMTPServerPort(port).withSMTPServerUsername(username);
    }

    public MailerRegularBuilderImpl withSMTPServer(@Nullable String host, @Nullable Integer port) {
        return this.withSMTPServerHost(host).withSMTPServerPort(port);
    }

    public MailerRegularBuilderImpl withSMTPServerHost(@Nullable String host) {
        this.host = host;
        return this;
    }

    public MailerRegularBuilderImpl withSMTPServerPort(@Nullable Integer port) {
        this.port = port;
        return this;
    }

    public MailerRegularBuilderImpl withSMTPServerUsername(@Nullable String username) {
        this.username = username;
        return this;
    }

    public MailerRegularBuilderImpl withSMTPServerPassword(@Nullable String password) {
        this.password = password;
        return this;
    }

    public MailerRegularBuilderImpl withCustomSSLFactoryClass(@Nullable String customSSLFactory) {
        this.customSSLFactory = customSSLFactory;
        return this;
    }

    public MailerRegularBuilderImpl withCustomSSLFactoryInstance(@Nullable SSLSocketFactory customSSLFactoryInstance) {
        this.customSSLFactoryInstance = customSSLFactoryInstance;
        return this;
    }

    public Mailer buildMailer() {
        return new MailerImpl(this);
    }

    @Nullable
    ServerConfig buildServerConfig() {
        if (!this.isTransportModeLoggingOnly() && this.getCustomMailer() == null) {
            MiscUtil.checkArgumentNotEmpty((Object)this.host, (String)"SMTP server host missing");
            int serverPort = Optional.ofNullable(this.port).orElse(this.transportStrategy.getDefaultServerPort());
            return new ServerConfigImpl((String)Preconditions.verifyNonnullOrEmpty((Object)this.getHost()), serverPort, this.username, this.password, this.customSSLFactory, this.customSSLFactoryInstance);
        }
        if (this.getCustomMailer() != null && this.host != null) {
            log.warn("Both custom mailer and SMTP server configured, ignoring server configuration");
        }
        return null;
    }

    @Nullable
    public String getHost() {
        return this.host;
    }

    @Nullable
    public Integer getPort() {
        return this.port;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @NotNull
    public TransportStrategy getTransportStrategy() {
        return this.transportStrategy;
    }

    @Nullable
    public String getCustomSSLFactory() {
        return this.customSSLFactory;
    }
}

