/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionmap.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.sessionmap.jdbc.JdbcException;
import org.openqa.selenium.internal.Require;

public class JdbcSessionMapOptions {
    private static final String SESSIONS_SECTION = "sessions";
    private final String jdbcUrl;
    private final String jdbcUser;
    private final String jdbcPassword;

    public JdbcSessionMapOptions(Config config) {
        Require.nonNull((String)"Config", (Object)config);
        try {
            this.jdbcUrl = config.get(SESSIONS_SECTION, "jdbc-url").orElse("");
            this.jdbcUser = config.get(SESSIONS_SECTION, "jdbc-user").orElse("");
            this.jdbcPassword = config.get(SESSIONS_SECTION, "jdbc-password").orElse("");
            if (this.jdbcUrl.isEmpty()) {
                throw new JdbcException("Missing JDBC Url value. Add sessions option value --jdbc-url <url-value>");
            }
        }
        catch (NoSuchElementException e) {
            throw new JdbcException("Missing session options. Check and add all the following options \n --jdbc-url <url> \n --jdbc-user <user> \n --jdbc-password <password>");
        }
    }

    public Connection getJdbcConnection() throws SQLException {
        return DriverManager.getConnection(this.jdbcUrl, this.jdbcUser, this.jdbcPassword);
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getJdbcUser() {
        return this.jdbcUser;
    }
}

