/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import org.openqa.selenium.Capabilities;
import org.openqa.selenium.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.browserlaunchers.LauncherUtils;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.BrowserOptions;

public abstract class AbstractBrowserLauncher
implements BrowserLauncher {
    protected String sessionId;
    private RemoteControlConfiguration configuration;
    protected Capabilities browserConfigurationOptions;

    public AbstractBrowserLauncher(String sessionId, RemoteControlConfiguration configuration, Capabilities browserOptions) {
        this.sessionId = sessionId;
        this.configuration = configuration;
        this.browserConfigurationOptions = configuration.copySettingsIntoBrowserOptions(browserOptions);
    }

    public void launchHTMLSuite(String suiteUrl, String browserURL) {
        this.launch(LauncherUtils.getDefaultHTMLSuiteUrl((String)browserURL, (String)suiteUrl, (!BrowserOptions.isSingleWindow(this.browserConfigurationOptions) ? 1 : 0) != 0, (int)0));
    }

    public void launchRemoteSession(String browserURL) {
        boolean browserSideLog = this.browserConfigurationOptions.is("browserSideLog");
        if (browserSideLog) {
            this.configuration.getSslCertificateGenerator().generateSSLCertsForLoggingHosts();
        }
        this.launch(LauncherUtils.getDefaultRemoteSessionUrl((String)browserURL, (String)this.sessionId, (!BrowserOptions.isSingleWindow(this.browserConfigurationOptions) ? 1 : 0) != 0, (int)0, (boolean)browserSideLog));
    }

    protected abstract void launch(String var1);

    public RemoteControlConfiguration getConfiguration() {
        return this.configuration;
    }

    public int getPort() {
        return this.configuration.getPortDriversShouldContact();
    }

    protected long getTimeout() {
        if (BrowserOptions.isTimeoutSet(this.browserConfigurationOptions)) {
            return BrowserOptions.getTimeoutInSeconds(this.browserConfigurationOptions);
        }
        return this.configuration.getTimeoutInSeconds();
    }

    @Deprecated
    protected String getCommandLineFlags() {
        String cmdLineFlags = BrowserOptions.getCommandLineFlags(this.browserConfigurationOptions);
        if (cmdLineFlags != null) {
            return cmdLineFlags;
        }
        return "";
    }

    protected String[] getCommandLineFlagsAsArray() {
        String cmdLineFlags = BrowserOptions.getCommandLineFlags(this.browserConfigurationOptions);
        if (cmdLineFlags != null) {
            return cmdLineFlags.split("\\s+");
        }
        return new String[0];
    }
}

