/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import com.google.common.collect.ImmutableMap;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.log.LoggingManager;
import org.openqa.selenium.remote.server.rest.RestishHandler;
import org.openqa.selenium.remote.server.rest.ResultType;

public class GetSessionLogsHandler
implements RestishHandler {
    private final Response response = new Response();

    public Response getResponse() {
        return this.response;
    }

    @Override
    public ResultType handle() throws Exception {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (SessionId sessionId : LoggingManager.perSessionLogHandler().getLoggedSessions()) {
            builder.put((Object)sessionId.toString(), (Object)LoggingManager.perSessionLogHandler().getAllLogsForSession(sessionId));
        }
        this.response.setValue((Object)builder.build());
        return ResultType.SUCCESS;
    }

    public String toString() {
        return String.format("[fetching session logs]", new Object[0]);
    }
}

