/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.emulation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.bidi.emulation.GeolocationCoordinates;
import org.openqa.selenium.bidi.emulation.GeolocationPositionError;

public class SetGeolocationOverrideParameters {
    private final Map<String, Object> map = new HashMap<String, Object>();

    public SetGeolocationOverrideParameters(GeolocationCoordinates coordinates) {
        if (coordinates == null) {
            throw new IllegalArgumentException("GeolocationCoordinates cannot be null");
        }
        this.map.put("coordinates", coordinates.toMap());
    }

    public SetGeolocationOverrideParameters(GeolocationPositionError error) {
        if (error == null) {
            throw new IllegalArgumentException("GeolocationPositionError cannot be null");
        }
        this.map.put("error", error.toMap());
    }

    public SetGeolocationOverrideParameters contexts(List<String> contexts) {
        if (contexts == null || contexts.isEmpty()) {
            throw new IllegalArgumentException("Contexts cannot be null or empty");
        }
        if (this.map.containsKey("userContexts")) {
            throw new IllegalArgumentException("Cannot specify both contexts and userContexts");
        }
        this.map.put("contexts", contexts);
        return this;
    }

    public SetGeolocationOverrideParameters userContexts(List<String> userContexts) {
        if (userContexts == null || userContexts.isEmpty()) {
            throw new IllegalArgumentException("User contexts cannot be null or empty");
        }
        if (this.map.containsKey("contexts")) {
            throw new IllegalArgumentException("Cannot specify both contexts and userContexts");
        }
        this.map.put("userContexts", userContexts);
        return this;
    }

    public Map<String, Object> toMap() {
        if (!this.map.containsKey("contexts") && !this.map.containsKey("userContexts")) {
            throw new IllegalStateException("Must specify either contexts or userContexts");
        }
        return Map.copyOf(this.map);
    }
}

