/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.Event;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.bidi.network.BeforeRequestSent;
import org.openqa.selenium.bidi.network.ResponseDetails;
import org.openqa.selenium.internal.Require;

public class Network
implements AutoCloseable {
    private final Set<String> browsingContextIds;
    private final BiDi bidi;
    private final Event<BeforeRequestSent> beforeRequestSentEvent = new Event<BeforeRequestSent>("network.beforeRequestSent", BeforeRequestSent::fromJsonMap);
    private final Event<ResponseDetails> responseStarted = new Event<ResponseDetails>("network.responseStarted", ResponseDetails::fromJsonMap);
    private final Event<ResponseDetails> responseCompleted = new Event<ResponseDetails>("network.responseStarted", ResponseDetails::fromJsonMap);

    public Network(WebDriver driver) {
        this(new HashSet<String>(), driver);
    }

    public Network(String browsingContextId, WebDriver driver) {
        this(Collections.singleton((String)Require.nonNull((String)"Browsing context id", (Object)browsingContextId)), driver);
    }

    public Network(Set<String> browsingContextIds, WebDriver driver) {
        Require.nonNull((String)"WebDriver", (Object)driver);
        Require.nonNull((String)"Browsing context id list", browsingContextIds);
        if (!(driver instanceof HasBiDi)) {
            throw new IllegalArgumentException("WebDriver instance must support BiDi protocol");
        }
        this.bidi = ((HasBiDi)driver).getBiDi();
        this.browsingContextIds = browsingContextIds;
    }

    public void onBeforeRequestSent(Consumer<BeforeRequestSent> consumer) {
        if (this.browsingContextIds.isEmpty()) {
            this.bidi.addListener(this.beforeRequestSentEvent, consumer);
        } else {
            this.bidi.addListener(this.browsingContextIds, this.beforeRequestSentEvent, consumer);
        }
    }

    public void onResponseStarted(Consumer<ResponseDetails> consumer) {
        if (this.browsingContextIds.isEmpty()) {
            this.bidi.addListener(this.responseStarted, consumer);
        } else {
            this.bidi.addListener(this.browsingContextIds, this.responseStarted, consumer);
        }
    }

    public void onResponseCompleted(Consumer<ResponseDetails> consumer) {
        if (this.browsingContextIds.isEmpty()) {
            this.bidi.addListener(this.responseCompleted, consumer);
        } else {
            this.bidi.addListener(this.browsingContextIds, this.responseStarted, consumer);
        }
    }

    @Override
    public void close() {
        this.bidi.clearListener(this.beforeRequestSentEvent);
        this.bidi.clearListener(this.responseStarted);
        this.bidi.clearListener(this.responseCompleted);
    }
}

