/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.openqa.selenium.grid.web.NoHandler;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;

public class CombinedHandler
implements Predicate<HttpRequest>,
Routable,
HttpHandler {
    private final Map<Routable, HttpHandler> handlers = new HashMap<Routable, HttpHandler>();

    public void addHandler(Routable handler) {
        this.handlers.put((Routable)Require.nonNull((String)"Handler", (Object)handler), (HttpHandler)handler);
    }

    @Override
    public boolean test(HttpRequest request) {
        return this.matches(request);
    }

    public boolean matches(HttpRequest req) {
        return this.handlers.keySet().stream().map(p -> p.matches(req)).reduce(Boolean::logicalOr).orElse(false);
    }

    public HttpResponse execute(HttpRequest req) {
        return this.handlers.entrySet().stream().filter(entry -> ((Routable)entry.getKey()).matches(req)).findFirst().map(Map.Entry::getValue).orElse(new NoHandler(new Json())).execute(req);
    }
}

